/*
 * Decompiled with CFR 0.152.
 */
package ct.server;

import ct.server.CtServerConfig;
import ct.server.database.DatabaseClient;
import ct.server.database.PlayerData;
import ct.server.database.PlayerTable;
import ct.server.events.PlayerWelcome;
import ct.server.http.ServiceServer;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Date;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CtServer
implements ModInitializer {
    public static final String MOD_ID = "ct-server";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"ct-server");
    public static final CtServerConfig CONFIG = CtServerConfig.createAndLoad();
    private static float currentTps = 0.0f;
    private static float currentMspt = 0.0f;
    private static int currentPlayerCount = 0;
    private static CtServer INSTANCE;
    private ServiceServer serviceServer;
    private DatabaseClient database;
    private final PlayerTable playerTable = new PlayerTable();

    public static CtServer getInstance() {
        return INSTANCE;
    }

    public ServiceServer serviceServer() {
        return this.serviceServer;
    }

    public DatabaseClient database() {
        return this.database;
    }

    public PlayerTable playerTable() {
        return this.playerTable;
    }

    public void onInitialize() {
        INSTANCE = this;
        LOGGER.info("Starting ct-server");
        try {
            this.database = new DatabaseClient();
            this.playerTable.ensureDatabaseCreated();
        }
        catch (SQLException e) {
            LOGGER.error("Database error", (Throwable)e);
        }
        try {
            this.serviceServer = new ServiceServer();
        }
        catch (IOException e) {
            LOGGER.error("Unable to start HTTP server", (Throwable)e);
        }
        ServerTickEvents.END_SERVER_TICK.register(server -> {
            currentMspt = server.method_54832();
            if (currentMspt != 0.0f) {
                currentTps = Math.min(20.0f, 1000.0f / currentMspt);
            }
        });
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            currentPlayerCount = server.method_3788() + 1;
            class_3222 player = handler.method_32311();
            PlayerData playerData = this.playerTable.getPlayerData(player.method_5667());
            if (playerData == null) {
                playerData = new PlayerData(handler.method_32311().method_5667());
                playerData.firstJoinedDate(new Date());
                playerData.name(player.method_5477().getString());
                this.playerTable.updatePlayerData(playerData);
                ((PlayerWelcome)PlayerWelcome.PLAYER_WELCOME.invoker()).playerWelcome(player, playerData, server);
                this.broadcastMessage(server, (class_2561)class_2561.method_43470((String)("Welcome " + player.method_5477().getString() + " to the server!")).method_27692(class_124.field_1060));
            } else if (!playerData.name().equals(player.method_5477().getString())) {
                playerData.name(player.method_5477().getString());
                this.playerTable.updatePlayerData(playerData);
            }
        });
        ServerPlayConnectionEvents.DISCONNECT.register((handler, server) -> {
            currentPlayerCount = server.method_3788() - 1;
        });
    }

    public void broadcastMessage(MinecraftServer server, class_2561 message) {
        for (class_3222 player : server.method_3760().method_14571()) {
            player.method_7353(message, false);
        }
    }

    public static float getTPS() {
        return currentTps;
    }

    public static float getMSPT() {
        return currentMspt;
    }

    public static int getPlayerCount() {
        return currentPlayerCount;
    }
}

