/*
 * Decompiled with CFR 0.152.
 */
package ct.discordbridge.discord;

import club.minnced.discord.webhook.WebhookClient;
import club.minnced.discord.webhook.WebhookClientBuilder;
import ct.discordbridge.Bridge;
import ct.discordbridge.discord.Events;
import java.util.EnumSet;
import java.util.List;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.JDABuilder;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.SelfUser;
import net.dv8tion.jda.api.entities.Webhook;
import net.dv8tion.jda.api.entities.channel.concrete.TextChannel;
import net.dv8tion.jda.api.events.message.MessageReceivedEvent;
import net.dv8tion.jda.api.events.message.MessageUpdateEvent;
import net.dv8tion.jda.api.events.session.ReadyEvent;
import net.dv8tion.jda.api.hooks.ListenerAdapter;
import net.dv8tion.jda.api.requests.GatewayIntent;
import net.dv8tion.jda.api.utils.cache.CacheFlag;

public class Client {
    private TextChannel chatChannel;
    private Webhook webhook;
    private JDA client;
    private final Events events = new Events();
    private Guild guild;
    private WebhookClient webhookClient;

    public Client() throws Exception {
        this.initialize();
    }

    public TextChannel chatChannel() {
        return this.chatChannel;
    }

    public Webhook webhook() {
        return this.webhook;
    }

    public WebhookClient webhookClient() {
        return this.webhookClient;
    }

    public JDA client() {
        return this.client;
    }

    public Events events() {
        return this.events;
    }

    public Guild guild() {
        return this.guild;
    }

    private void initialize() {
        this.client = JDABuilder.create((String)Bridge.CONFIG.token(), EnumSet.of(GatewayIntent.GUILD_MESSAGES, GatewayIntent.GUILD_MEMBERS, GatewayIntent.MESSAGE_CONTENT)).disableCache(CacheFlag.ACTIVITY, new CacheFlag[]{CacheFlag.VOICE_STATE, CacheFlag.EMOJI, CacheFlag.STICKER, CacheFlag.CLIENT_STATUS, CacheFlag.ONLINE_STATUS, CacheFlag.SCHEDULED_EVENTS}).addEventListeners(new Object[]{new DiscordEvents()}).build();
    }

    private class DiscordEvents
    extends ListenerAdapter {
        private DiscordEvents() {
        }

        public void onReady(ReadyEvent event) {
            SelfUser self = Client.this.client.getSelfUser();
            Bridge.LOGGER.info("Logged in as {}", (Object)self.getAsTag());
            Client.this.chatChannel = Client.this.client.getTextChannelById(Bridge.CONFIG.channelId());
            if (Client.this.chatChannel == null) {
                Bridge.LOGGER.error("Channel not found! Set an existing channel ID that I can see!");
                Client.this.client.shutdown();
                return;
            }
            Client.this.guild = Client.this.chatChannel.getGuild();
            String webhookName = Bridge.CONFIG.name();
            List webhooks = (List)Client.this.chatChannel.retrieveWebhooks().complete();
            webhooks.stream().filter(wh -> wh.getName().equals(webhookName)).findFirst().ifPresent(wh -> {
                Client.this.webhook = wh;
            });
            if (Client.this.webhook == null) {
                Client.this.webhook = (Webhook)Client.this.chatChannel.createWebhook(webhookName).complete();
            }
            Client.this.webhookClient = new WebhookClientBuilder(Client.this.webhook.getUrl()).setDaemon(true).buildJDA();
        }

        public void onMessageReceived(MessageReceivedEvent event) {
            Client.this.events.onMessageCreate(event);
        }

        public void onMessageUpdate(MessageUpdateEvent event) {
            Client.this.events.onMessageEdit(event);
        }
    }
}

