/*
 * Decompiled with CFR 0.152.
 */
package ct.discordbridge.discord;

import ct.discordbridge.Bridge;
import ct.discordbridge.ChatComponents;
import ct.discordbridge.Colors;
import ct.discordbridge.events.DiscordMessage;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.MessageType;
import net.dv8tion.jda.api.entities.Role;
import net.dv8tion.jda.api.entities.User;
import net.dv8tion.jda.api.entities.channel.ChannelType;
import net.dv8tion.jda.api.entities.channel.middleman.GuildChannel;
import net.dv8tion.jda.api.entities.channel.unions.MessageChannelUnion;
import net.dv8tion.jda.api.events.message.MessageReceivedEvent;
import net.dv8tion.jda.api.events.message.MessageUpdateEvent;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;

public class Events {
    private static final Pattern mentionPattern = Pattern.compile("(<@[!&]?\\d+>|<#\\d+>)");
    private static final Pattern integerPattern = Pattern.compile("\\d+");

    public static List<String> splitMessage(String message) {
        ArrayList<String> parts = new ArrayList<String>();
        Matcher matcher = mentionPattern.matcher(message);
        int lastEnd = 0;
        while (matcher.find()) {
            if (matcher.start() > lastEnd) {
                parts.add(message.substring(lastEnd, matcher.start()));
            }
            parts.add(matcher.group(1));
            lastEnd = matcher.end();
        }
        if (lastEnd < message.length()) {
            parts.add(message.substring(lastEnd));
        }
        return parts;
    }

    public void onMessageCreate(MessageReceivedEvent event) {
        Message message = event.getMessage();
        MessageChannelUnion channel = message.getChannel();
        if (!channel.getId().equals(Bridge.CONFIG.channelId())) {
            return;
        }
        Member member = event.getMember();
        if (member == null) {
            return;
        }
        if (member.getUser().isBot()) {
            return;
        }
        this.buildMessage(message, member, false);
    }

    public void onMessageEdit(MessageUpdateEvent event) {
        Message message = event.getMessage();
        MessageChannelUnion channel = message.getChannel();
        if (!channel.getId().equals(Bridge.CONFIG.channelId())) {
            return;
        }
        Member member = event.getMember();
        if (member == null) {
            return;
        }
        if (member.getUser().isBot()) {
            return;
        }
        this.buildMessage(message, member, true);
    }

    /*
     * WARNING - void declaration
     */
    public void buildMessage(Message message, Member member, boolean isEdited) {
        void var14_21;
        ((DiscordMessage)DiscordMessage.MESSAGE_CREATE.invoker()).messageCreate(message, member, isEdited);
        int memberColor = NamedTextColor.WHITE.value();
        Color nullableMemberColor = member.getColor();
        if (nullableMemberColor != null) {
            memberColor = nullableMemberColor.getRGB();
        }
        Component memberComponent = ChatComponents.makeUser(member.getEffectiveName(), member.getAsMention() + ": ", memberColor, (Component)Component.empty());
        Component replyComponent = null;
        if (message.getType() == MessageType.INLINE_REPLY && message.getReferencedMessage() != null) {
            Component referenceMemberComponent;
            Message referencedMessage = message.getReferencedMessage();
            Member referenceMember = referencedMessage.getMember();
            if (referenceMember != null) {
                int referenceMemberColor = NamedTextColor.WHITE.value();
                Color nullableReferenceMemberColor = member.getColor();
                if (nullableReferenceMemberColor != null) {
                    referenceMemberColor = nullableReferenceMemberColor.getRGB();
                }
                referenceMemberComponent = ChatComponents.makeUser(referenceMember.getEffectiveName(), referenceMember.getAsMention() + ": ", referenceMemberColor, (Component)Component.empty());
            } else if (referencedMessage.getMember() != null) {
                User referenceAuthor = referencedMessage.getAuthor();
                referenceMemberComponent = ChatComponents.makeUser(referenceAuthor.getName(), referenceAuthor.getAsMention() + ": ", NamedTextColor.WHITE.value(), (Component)Component.empty());
            } else {
                User referenceAuthor = referencedMessage.getAuthor();
                referenceMemberComponent = ChatComponents.makeUser(referenceAuthor.getName(), referenceAuthor.getName() + ": ", NamedTextColor.WHITE.value(), (Component)Component.empty());
            }
            replyComponent = ChatComponents.makeReplyHeader(referenceMemberComponent, (Component)Component.text((String)referencedMessage.getContentDisplay()));
        }
        String messageContent = message.getContentRaw();
        TextComponent messageComponent = Component.empty();
        List<String> splitContent = Events.splitMessage(messageContent);
        List memberMentions = message.getMentions().getMembers();
        List roleMentions = message.getMentions().getRoles();
        for (String string : splitContent) {
            if (string.matches(mentionPattern.pattern())) {
                Matcher matcher = integerPattern.matcher(string);
                if (matcher.find()) {
                    String snowflakeId = matcher.group();
                    if (string.startsWith("<@&")) {
                        Optional<Role> mentionedRoleOpt = roleMentions.stream().filter(p -> p.getId().equals(snowflakeId)).findFirst();
                        if (mentionedRoleOpt.isPresent()) {
                            Role mentionedRole = mentionedRoleOpt.get();
                            int color = mentionedRole.getColorRaw();
                            if (color == 0) {
                                color = 10070709;
                            }
                            messageComponent = messageComponent.append(ChatComponents.makeUser(mentionedRole.getName(), mentionedRole.getAsMention() + ": ", color, ChatComponents.mentionIcon));
                            continue;
                        }
                        messageComponent = messageComponent.append(ChatComponents.makeUser("unknown-role", String.format("<@&%s>: ", snowflakeId), NamedTextColor.WHITE.value(), ChatComponents.mentionIcon));
                        continue;
                    }
                    if (string.startsWith("<@") || string.startsWith("<@!")) {
                        Optional<Member> mentionedOpt = memberMentions.stream().filter(p -> p.getId().equals(snowflakeId)).findFirst();
                        if (mentionedOpt.isPresent()) {
                            Member mentioned = mentionedOpt.get();
                            messageComponent = messageComponent.append(ChatComponents.makeUser(mentioned.getEffectiveName(), mentioned.getAsMention() + ": ", Colors.MENTION.value(), ChatComponents.mentionIcon));
                            continue;
                        }
                        messageComponent = messageComponent.append(ChatComponents.makeUser("unknown-user", String.format("<@%s>: ", snowflakeId), Colors.MENTION.value(), ChatComponents.mentionIcon));
                        continue;
                    }
                    if (!string.startsWith("<#")) continue;
                    GuildChannel mentionedChannel = message.getJDA().getGuildChannelById(snowflakeId);
                    if (mentionedChannel != null && ChannelType.guildTypes().contains(mentionedChannel.getType())) {
                        messageComponent = messageComponent.append(ChatComponents.makeUser(mentionedChannel.getName(), mentionedChannel.getAsMention() + ": ", Colors.MENTION.value(), ChatComponents.channelIcon));
                        continue;
                    }
                    messageComponent = messageComponent.append(ChatComponents.makeUser("unknown", String.format("<#%s>: ", snowflakeId), Colors.MENTION.value(), ChatComponents.channelIcon));
                    continue;
                }
                messageComponent = messageComponent.append((Component)Component.text((String)string));
                continue;
            }
            messageComponent = messageComponent.append((Component)Component.text((String)string));
        }
        List attachments = message.getAttachments();
        if (!messageContent.isEmpty()) {
            messageComponent = messageComponent.appendSpace();
        }
        for (Message.Attachment attachment : attachments) {
            messageComponent = messageComponent.append(ChatComponents.makeAttachment(attachment.getFileName(), attachment.getUrl()));
        }
        Component component = ChatComponents.makeMessage(memberComponent, replyComponent, (Component)messageComponent);
        if (isEdited) {
            Component component2 = component.append((Component)Component.text((String)"(edited)", (TextColor)NamedTextColor.GRAY));
        }
        Bridge.enqueueMessage((Component)var14_21);
    }
}

