/*
 * Decompiled with CFR 0.152.
 */
package io.sc3.plethora.core;

import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import io.sc3.plethora.api.converter.IConverter;
import io.sc3.plethora.api.converter.IConverterRegistry;
import io.sc3.plethora.api.reference.IReference;
import io.sc3.plethora.core.ConverterReference;
import io.sc3.plethora.core.TargetedRegisteredValue;
import io.sc3.plethora.core.collections.ClassIteratorIterable;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ConverterRegistry
implements IConverterRegistry {
    public static final ConverterRegistry instance = new ConverterRegistry();
    private final List<TargetedRegisteredValue<? extends IConverter<?, ?>>> all = new ArrayList();
    private final Multimap<Class<?>, IConverter<?, ?>> converters = MultimapBuilder.hashKeys().hashSetValues().build();

    void registerConverter(@Nonnull TargetedRegisteredValue<? extends IConverter<?, ?>> converter) {
        Objects.requireNonNull(converter, "converter cannot be null");
        this.all.add(converter);
    }

    @Override
    public <T extends IConverter<?, ?>> void registerConverter(@Nonnull String name, @Nullable String mod, @Nonnull Class<?> target, @Nonnull T value) {
        Objects.requireNonNull(name, "name cannot be null");
        Objects.requireNonNull(target, "target cannot be null");
        Objects.requireNonNull(value, "value cannot be null");
        this.registerConverter(new TargetedRegisteredValue<T>(name, mod, target, value));
    }

    void build() {
        TargetedRegisteredValue.buildCache(this.all, this.converters);
    }

    @Nonnull
    public Iterable<Object> convertAll(final @Nonnull Object input) {
        Objects.requireNonNull(input, "input cannot be null");
        return new Iterable<Object>(){

            @Override
            @Nonnull
            public Iterator<Object> iterator() {
                return new ConverterIterator(input);
            }
        };
    }

    public void extendConverted(@Nonnull List<String> keys, @Nonnull List<Object> values, @Nonnull List<Object> references, int startPoint) {
        int i2;
        Objects.requireNonNull(keys, "keys cannot be null");
        Objects.requireNonNull(values, "values cannot be null");
        Objects.requireNonNull(references, "references in cannot be null");
        if (keys.size() != values.size()) {
            throw new IllegalStateException("lists must be of the same size");
        }
        if (keys.size() != references.size()) {
            throw new IllegalStateException("lists must be of the same size");
        }
        Object2IntOpenHashMap positions = new Object2IntOpenHashMap();
        positions.defaultReturnValue(-1);
        for (i2 = 0; i2 < values.size(); ++i2) {
            positions.put(values.get(i2), i2);
        }
        for (i2 = startPoint; i2 < values.size(); ++i2) {
            Object target = values.get(i2);
            Class<?> initial = target.getClass();
            for (Class<?> klass : new ClassIteratorIterable(initial)) {
                for (IConverter converter : this.converters.get(klass)) {
                    Object converted = converter.convert(target);
                    if (converted == null) continue;
                    int existing = positions.getInt(converted);
                    if (existing == positions.defaultReturnValue()) {
                        positions.put(converted, keys.size());
                        keys.add(keys.get(i2));
                        values.add(converted);
                        boolean isConstant = converter.isConstant();
                        if (isConstant) {
                            Object reference = references.get(i2);
                            if (reference instanceof ConverterReference) {
                                isConstant = false;
                            } else if (reference instanceof IReference) {
                                isConstant = ((IReference)reference).isConstant();
                            }
                        }
                        references.add(isConstant ? converted : new ConverterReference(i2, klass, converter));
                        continue;
                    }
                    if (!ConverterRegistry.requiresInsertion(keys, values, existing, keys.get(i2), converted)) continue;
                    positions.put(converted, keys.size());
                    keys.add(keys.get(i2));
                    values.add(converted);
                    Object reference = references.get(existing);
                    references.add(reference instanceof ConverterReference && ((ConverterReference)reference).isIdentity() ? reference : ConverterReference.identity(existing));
                }
            }
        }
    }

    public void extendConverted(@Nonnull List<String> keys, @Nonnull List<Object> values, int startPoint) {
        int i2;
        Objects.requireNonNull(keys, "keys cannot be null");
        Objects.requireNonNull(values, "values cannot be null");
        if (keys.size() != values.size()) {
            throw new IllegalStateException("lists must be of the same size");
        }
        Object2IntOpenHashMap positions = new Object2IntOpenHashMap();
        positions.defaultReturnValue(-1);
        for (i2 = 0; i2 < values.size(); ++i2) {
            positions.put(values.get(i2), i2);
        }
        for (i2 = startPoint; i2 < values.size(); ++i2) {
            Object target = values.get(i2);
            Class<?> initial = target.getClass();
            for (Class<?> klass : new ClassIteratorIterable(initial)) {
                for (IConverter converter : this.converters.get(klass)) {
                    int existing;
                    Object converted = converter.convert(target);
                    if (converted == null || (existing = positions.getInt(converted)) != positions.defaultReturnValue() && !ConverterRegistry.requiresInsertion(keys, values, existing, keys.get(i2), converted)) continue;
                    positions.put(converted, keys.size());
                    keys.add(keys.get(i2));
                    values.add(converted);
                }
            }
        }
    }

    private static boolean requiresInsertion(List<String> keys, List<Object> values, int existing, String key, Object value) {
        for (int i2 = existing; i2 >= 0; --i2) {
            if (!values.get(i2).equals(value) || !keys.get(i2).equals(key)) continue;
            return false;
        }
        return true;
    }

    private class ConverterIterator
    implements Iterator<Object> {
        private final Set<Object> allConverted = new HashSet<Object>();
        private final Queue<Object> queue = new ArrayDeque<Object>();

        ConverterIterator(Object input) {
            this.allConverted.add(input);
            this.queue.offer(input);
        }

        @Override
        public boolean hasNext() {
            return !this.queue.isEmpty();
        }

        @Override
        public Object next() {
            Object next = this.queue.remove();
            Class<?> initial = next.getClass();
            for (Class<?> klass : new ClassIteratorIterable(initial)) {
                for (IConverter converter : ConverterRegistry.this.converters.get(klass)) {
                    Object converted = converter.convert(next);
                    if (converted == null || !this.allConverted.add(converted)) continue;
                    this.queue.offer(converted);
                }
            }
            return next;
        }

        @Override
        public void remove() {
            Iterator.super.remove();
        }
    }
}

