/*
 * Decompiled with CFR 0.152.
 */
package io.sc3.plethora.core;

import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.peripheral.IComputerAccess;
import io.sc3.plethora.core.RegisteredMethod;
import io.sc3.plethora.core.UnbakedContext;
import java.util.List;
import javax.annotation.Nonnull;

public class MethodWrapper {
    private final List<RegisteredMethod<?>> methods;
    private final List<UnbakedContext<?>> contexts;
    private final String[] names;

    public MethodWrapper(List<RegisteredMethod<?>> methods, List<UnbakedContext<?>> contexts) {
        this.contexts = contexts;
        this.methods = methods;
        this.names = new String[methods.size()];
        String[] names = this.names;
        for (int i2 = 0; i2 < names.length; ++i2) {
            names[i2] = methods.get(i2).getMethod().getName();
        }
    }

    @Nonnull
    public String[] getMethodNames() {
        return this.names;
    }

    public RegisteredMethod<?> getMethod(int i2) {
        return this.methods.get(i2);
    }

    public UnbakedContext<?> getContext(int i2) {
        return this.contexts.get(i2);
    }

    protected static Object[] getReferences(IComputerAccess access, ILuaContext context) {
        return new Object[]{access, context};
    }

    boolean equalMethods(MethodWrapper other) {
        if (this.methods.equals(other.methods)) {
            return true;
        }
        if (this.methods.size() != other.methods.size()) {
            return false;
        }
        for (RegisteredMethod<?> method : this.methods) {
            if (other.methods.contains(method)) continue;
            return false;
        }
        return true;
    }
}

