/*
 * Decompiled with CFR 0.152.
 */
package io.sc3.plethora.gameplay.modules.kinetic;

import com.mojang.authlib.GameProfile;
import dan200.computercraft.api.lua.IArguments;
import dan200.computercraft.api.lua.LuaException;
import io.sc3.plethora.Plethora;
import io.sc3.plethora.api.IPlayerOwnable;
import io.sc3.plethora.api.method.ArgumentExt;
import io.sc3.plethora.api.method.FutureMethodResult;
import io.sc3.plethora.api.method.IContext;
import io.sc3.plethora.api.method.IUnbakedContext;
import io.sc3.plethora.api.module.IModuleContainer;
import io.sc3.plethora.api.module.SubtargetedModuleMethod;
import io.sc3.plethora.core.ContextHelpers;
import io.sc3.plethora.gameplay.PlethoraFakePlayer;
import io.sc3.plethora.gameplay.registry.PlethoraModules;
import io.sc3.plethora.mixin.ServerPlayNetworkHandlerAdapter;
import io.sc3.plethora.util.Helpers;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3532;

public class KineticMethods {
    private static final double TERMINAL_VELOCITY = -2.0;
    public static final SubtargetedModuleMethod<class_1309> LAUNCH = SubtargetedModuleMethod.of("launch", PlethoraModules.KINETIC_M, class_1309.class, "function(yaw:number, pitch:number, power:number) -- Launch the entity in a set direction", KineticMethods::launch);

    private static FutureMethodResult launch(@Nonnull IUnbakedContext<IModuleContainer> unbaked, @Nonnull IArguments args) throws LuaException {
        float yaw = (float)Helpers.normaliseAngle(args.getFiniteDouble(0));
        float pitch = (float)Helpers.normaliseAngle(args.getFiniteDouble(1));
        float power = (float)ArgumentExt.assertDoubleBetween(args, 2, 0.0, Plethora.config.kinetic.launchMax, "Power out of range (%s).");
        return unbaked.getCostHandler().await((double)power * Plethora.config.kinetic.launchCost, FutureMethodResult.nextTick(() -> {
            class_1309 entity = unbaked.bake().getContext("origin", class_1309.class);
            KineticMethods.launch((class_1297)entity, yaw, pitch, power);
            return FutureMethodResult.empty();
        }));
    }

    public static void launch(class_1297 entity, float yaw, float pitch, float power) {
        class_1309 living;
        float motionX = -class_3532.method_15374((float)(yaw / 180.0f * (float)Math.PI)) * class_3532.method_15362((float)(pitch / 180.0f * (float)Math.PI));
        float motionZ = class_3532.method_15362((float)(yaw / 180.0f * (float)Math.PI)) * class_3532.method_15362((float)(pitch / 180.0f * (float)Math.PI));
        float motionY = -class_3532.method_15374((float)(pitch / 180.0f * (float)Math.PI));
        power /= class_3532.method_15355((float)(motionX * motionX + motionY * motionY + motionZ * motionZ));
        if (entity instanceof class_1309 && (living = (class_1309)entity).method_6128()) {
            power = (float)((double)power * Plethora.config.kinetic.launchElytraScale);
        }
        entity.method_5762((double)(motionX * power), (double)(motionY * power) * Plethora.config.kinetic.launchYScale, (double)(motionZ * power));
        entity.field_6037 = true;
        if (Plethora.config.kinetic.launchFallReset && motionY > 0.0f) {
            double entityVelY = entity.method_18798().field_1351;
            if (entityVelY > 0.0) {
                entity.field_6017 = 0.0f;
            } else if (entityVelY > -2.0) {
                entity.field_6017 = (float)((double)entity.field_6017 * (entityVelY / -2.0));
            }
        }
        if (Plethora.config.kinetic.launchFloatReset && entity instanceof class_3222) {
            class_3222 spe = (class_3222)entity;
            ((ServerPlayNetworkHandlerAdapter)spe.field_13987).setFloatingTicks(0);
        }
    }

    public static KineticMethodContext getContext(@Nonnull IUnbakedContext<IModuleContainer> unbaked) throws LuaException {
        IContext<IModuleContainer> ctx = unbaked.bake();
        class_1309 entity = ContextHelpers.fromSubtarget(ctx, class_1309.class);
        IPlayerOwnable ownable = ContextHelpers.fromContext(ctx, IPlayerOwnable.class, "origin");
        return new KineticMethodContext(ctx, entity, ownable);
    }

    public static KineticMethodPlayer getPlayer(@Nonnull KineticMethodContext ctx) throws LuaException {
        PlethoraFakePlayer fakePlayer;
        Object player;
        class_1309 entity = ctx.entity();
        IPlayerOwnable ownable = ctx.ownable();
        class_1937 class_19372 = entity.method_5770();
        if (!(class_19372 instanceof class_3218)) {
            throw new LuaException("Cannot run on client");
        }
        class_3218 world = (class_3218)class_19372;
        if (entity instanceof class_3222) {
            class_3222 spe;
            player = spe = (class_3222)entity;
            fakePlayer = null;
        } else {
            if (entity instanceof class_1657) {
                throw new LuaException("An unexpected player was used");
            }
            if (ownable == null) {
                throw new LuaException("Could not determine owner");
            }
            GameProfile profile = ownable.getOwningProfile();
            if (profile == null) {
                throw new LuaException("Could not determine owner profile");
            }
            fakePlayer = new PlethoraFakePlayer(world, (class_1297)entity, ownable.getOwningProfile());
            player = fakePlayer;
        }
        return new KineticMethodPlayer(world, (class_3222)player, fakePlayer);
    }

    public record KineticMethodContext(IContext<IModuleContainer> context, class_1309 entity, @Nullable IPlayerOwnable ownable) {
    }

    public record KineticMethodPlayer(class_3218 world, class_3222 player, PlethoraFakePlayer fakePlayer) {
    }
}

