/*
 * Decompiled with CFR 0.152.
 */
package cc.reconnected.discordbridge.discord;

import cc.reconnected.discordbridge.Bridge;
import cc.reconnected.discordbridge.ChatComponents;
import cc.reconnected.discordbridge.events.DiscordMessageEvents;
import cc.reconnected.discordbridge.parser.MarkdownParser;
import cc.reconnected.discordbridge.parser.MentionNodeParser;
import eu.pb4.placeholders.api.parsers.NodeParser;
import java.awt.Color;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.List;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.MessageType;
import net.dv8tion.jda.api.entities.User;
import net.dv8tion.jda.api.entities.channel.unions.MessageChannelUnion;
import net.dv8tion.jda.api.events.message.MessageReceivedEvent;
import net.dv8tion.jda.api.events.message.MessageUpdateEvent;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.serializer.json.JSONComponentSerializer;
import net.minecraft.class_2561;

public class Events {
    private final HashMap<String, String> messageCache = new HashMap();

    private boolean isActuallyEdited(String id, String content) {
        MessageDigest messageDigest;
        try {
            messageDigest = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            Bridge.LOGGER.error("sha256 no longer exists :(", (Throwable)e);
            return true;
        }
        String digest = new String(messageDigest.digest(content.getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
        if (!this.messageCache.containsKey(id)) {
            this.messageCache.put(id, digest);
            return false;
        }
        if (!this.messageCache.get(id).equals(content)) {
            this.messageCache.put(id, content);
            return true;
        }
        return false;
    }

    public void onMessageCreate(MessageReceivedEvent event) {
        Message message = event.getMessage();
        MessageChannelUnion channel = message.getChannel();
        if (!channel.getId().equals(Bridge.CONFIG.channelId())) {
            return;
        }
        Member member = event.getMember();
        if (member == null) {
            return;
        }
        if (member.getUser().isBot()) {
            return;
        }
        this.buildMessage(message, member, false);
    }

    public void onMessageEdit(MessageUpdateEvent event) {
        Message message = event.getMessage();
        MessageChannelUnion channel = message.getChannel();
        if (!channel.getId().equals(Bridge.CONFIG.channelId())) {
            return;
        }
        Member member = event.getMember();
        if (member == null) {
            return;
        }
        if (member.getUser().isBot()) {
            return;
        }
        this.buildMessage(message, member, true);
    }

    public void buildMessage(Message message, Member member, boolean isEdited) {
        boolean isActuallyEdited = this.isActuallyEdited(message.getId(), message.getContentRaw());
        if (isEdited && !isActuallyEdited) {
            return;
        }
        isEdited = isActuallyEdited;
        if (isEdited) {
            ((DiscordMessageEvents.MessageEdit)DiscordMessageEvents.MESSAGE_EDIT.invoker()).onEdit(message, member);
        } else {
            ((DiscordMessageEvents.MessageCreate)DiscordMessageEvents.MESSAGE_CREATE.invoker()).onCreate(message, member);
        }
        int memberColor = NamedTextColor.WHITE.value();
        Color nullableMemberColor = member.getColor();
        if (nullableMemberColor != null) {
            memberColor = nullableMemberColor.getRGB();
        }
        Component memberComponent = ChatComponents.makeUser(member.getEffectiveName(), member.getAsMention() + ": ", memberColor, (Component)Component.empty());
        Component replyComponent = null;
        if (message.getType() == MessageType.INLINE_REPLY && message.getReferencedMessage() != null) {
            Component referenceMemberComponent;
            Message referencedMessage = message.getReferencedMessage();
            Member referenceMember = referencedMessage.getMember();
            if (referenceMember != null) {
                int referenceMemberColor = NamedTextColor.WHITE.value();
                Color nullableReferenceMemberColor = member.getColor();
                if (nullableReferenceMemberColor != null) {
                    referenceMemberColor = nullableReferenceMemberColor.getRGB();
                }
                referenceMemberComponent = ChatComponents.makeUser(referenceMember.getEffectiveName(), referenceMember.getAsMention() + ": ", referenceMemberColor, (Component)Component.empty());
            } else if (referencedMessage.getMember() != null) {
                User referenceAuthor = referencedMessage.getAuthor();
                referenceMemberComponent = ChatComponents.makeUser(referenceAuthor.getName(), referenceAuthor.getAsMention() + ": ", NamedTextColor.WHITE.value(), (Component)Component.empty());
            } else {
                User referenceAuthor = referencedMessage.getAuthor();
                referenceMemberComponent = ChatComponents.makeUser(referenceAuthor.getName(), referenceAuthor.getName() + ": ", NamedTextColor.WHITE.value(), (Component)Component.empty());
            }
            replyComponent = ChatComponents.makeReplyHeader(referenceMemberComponent, (Component)Component.text((String)referencedMessage.getContentDisplay()));
        }
        String messageContent = message.getContentRaw();
        TextComponent messageComponent = Component.empty();
        NodeParser parser = NodeParser.merge((NodeParser[])new NodeParser[]{new MentionNodeParser(message), MarkdownParser.contentParser});
        class_2561 mdContentVan = parser.parseNode(messageContent).toText();
        String json = class_2561.class_2562.method_10867((class_2561)mdContentVan);
        Component mdContent = JSONComponentSerializer.json().deserialize((Object)json);
        messageComponent = messageComponent.append(mdContent);
        List attachments = message.getAttachments();
        if (!messageContent.isEmpty()) {
            messageComponent = messageComponent.appendSpace();
        }
        for (Message.Attachment attachment : attachments) {
            messageComponent = messageComponent.append(ChatComponents.makeAttachment(attachment.getFileName(), attachment.getUrl()));
            messageComponent = messageComponent.appendSpace();
        }
        Component outputComponent = ChatComponents.makeMessage(memberComponent, replyComponent, (Component)messageComponent);
        if (isEdited) {
            outputComponent = outputComponent.append((Component)Component.text((String)"(edited)", (TextColor)NamedTextColor.GRAY));
        }
        Bridge.enqueueMessage(outputComponent);
    }
}

