/*
 * Decompiled with CFR 0.152.
 */
package cc.reconnected.pronouns;

import cc.reconnected.server.RccServer;
import cc.reconnected.server.database.PlayerData;
import cc.reconnected.server.database.PlayerTable;
import java.util.Objects;
import java.util.UUID;
import java.util.regex.Pattern;
import me.neznamy.tab.api.TabAPI;
import net.minecraft.class_2168;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Pronouns {
    static MinecraftServer server;
    static Logger LOGGER;

    public static void onServerStart(MinecraftServer server) {
        Pronouns.server = server;
        TabAPI.getInstance().getPlaceholderManager().registerPlayerPlaceholder("%pronoun1%", 500, player -> {
            if (player == null) {
                return "";
            }
            String pronouns = Pronouns.getPronouns(player.getUniqueId());
            if (pronouns == null) {
                return "";
            }
            return pronouns.split("(\\s|,|/)", 2)[0];
        });
        TabAPI.getInstance().getPlaceholderManager().registerPlayerPlaceholder("%pronoun2%", 500, player -> {
            if (player == null) {
                return "";
            }
            String pronouns = Pronouns.getPronouns(player.getUniqueId());
            if (pronouns == null) {
                return "";
            }
            return pronouns.split("(\\s|,|/)", 2)[1];
        });
    }

    public static Boolean validatePronoun(String pronoun) {
        return Pattern.matches("^(he|him|she|her|it|its|they|them|any|ask|avoid|other)$", pronoun);
    }

    public static String setPronouns(class_2168 player, String pronoun) {
        if (Objects.equals(pronoun, "clear")) {
            PlayerTable table = RccServer.getInstance().playerTable();
            PlayerData pData = table.getPlayerData(Objects.requireNonNull(player.method_44023()).method_5667());
            if (pData == null) {
                return "Warning: Player Data Missing, this change will not survive a server restart.";
            }
            pData.pronouns("");
            table.updatePlayerData(pData);
            return "Cleared Pronouns";
        }
        if (!Pronouns.validatePronoun(pronoun).booleanValue()) {
            return "Invalid pronouns.";
        }
        PlayerTable table = RccServer.getInstance().playerTable();
        PlayerData pData = table.getPlayerData(Objects.requireNonNull(player.method_44023()).method_5667());
        if (pData == null) {
            return "Error: Player Data Missing. Try again later.";
        }
        pData.pronouns(pronoun + ",");
        table.updatePlayerData(pData);
        return "Changed Pronouns";
    }

    public static String setPronouns(class_2168 player, String pronoun1, String pronoun2) {
        if (!Pronouns.validatePronoun(pronoun1).booleanValue() || !Pronouns.validatePronoun(pronoun2).booleanValue()) {
            return "Invalid pronouns.";
        }
        PlayerTable table = RccServer.getInstance().playerTable();
        PlayerData pData = table.getPlayerData(Objects.requireNonNull(player.method_44023()).method_5667());
        if (pData == null) {
            return "Error: Player Data Missing. Try again later.";
        }
        pData.pronouns(pronoun1 + "/" + pronoun2);
        table.updatePlayerData(pData);
        return "Changed Pronouns";
    }

    public static String getPronouns(UUID player) {
        PlayerTable table = RccServer.getInstance().playerTable();
        PlayerData pData = table.getPlayerData(player);
        if (pData == null) {
            return null;
        }
        if (pData.pronouns().isBlank()) {
            return ",";
        }
        return pData.pronouns();
    }

    static {
        LOGGER = LoggerFactory.getLogger((String)"rcc-pronouns");
    }
}

