/*
 * Decompiled with CFR 0.152.
 */
package io.sc3.plethora.core;

import com.google.common.collect.MapMaker;
import dan200.computercraft.api.lua.LuaException;
import io.sc3.plethora.Plethora;
import io.sc3.plethora.api.method.FutureMethodResult;
import io.sc3.plethora.api.method.ICostHandler;
import io.sc3.plethora.util.config.PlethoraConfig;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\b\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\b\u0010\tJ%\u0010\b\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00042\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\nH\u0016\u00a2\u0006\u0004\b\b\u0010\u000bJ\u0017\u0010\r\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000f\u0010\u000f\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u000f\u0010\u0012\u001a\u00020\u0011H\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0003R\u0014\u0010\u0016\u001a\u00020\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0016\u0010\u0017\u001a\u00020\u00048\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001a"}, d2={"Lio/sc3/plethora/core/DefaultCostHandler;", "Lio/sc3/plethora/api/method/ICostHandler;", "<init>", "()V", "", "amount", "Lio/sc3/plethora/api/method/FutureMethodResult;", "next", "await", "(DLio/sc3/plethora/api/method/FutureMethodResult;)Lio/sc3/plethora/api/method/FutureMethodResult;", "Ljava/util/concurrent/Callable;", "(DLjava/util/concurrent/Callable;)Lio/sc3/plethora/api/method/FutureMethodResult;", "", "consume", "(D)Z", "get", "()D", "", "regen", "Lio/sc3/plethora/util/config/PlethoraConfig$CostSystem;", "getCfg", "()Lio/sc3/plethora/util/config/PlethoraConfig$CostSystem;", "cfg", "value", "D", "Companion", "GitHub2"})
@SourceDebugExtension(value={"SMAP\nDefaultCostHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultCostHandler.kt\nio/sc3/plethora/core/DefaultCostHandler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,116:1\n1#2:117\n*E\n"})
public final class DefaultCostHandler
implements ICostHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private double value;
    @NotNull
    private static final Map<Object, DefaultCostHandler> handlers;

    public DefaultCostHandler() {
        this.value = this.getCfg().initial;
    }

    private final PlethoraConfig.CostSystem getCfg() {
        return Plethora.config.costSystem;
    }

    @Override
    public synchronized double get() {
        return this.value;
    }

    @Override
    public synchronized boolean consume(double amount) {
        if (!(amount >= 0.0)) {
            boolean bl = false;
            String string = "amount must be >= 0";
            throw new IllegalArgumentException(string.toString());
        }
        if (this.getCfg().allowNegative ? this.value <= 0.0 : amount > this.value) {
            return false;
        }
        this.value -= amount;
        return true;
    }

    @Override
    @NotNull
    public FutureMethodResult await(double amount, @NotNull FutureMethodResult next) throws LuaException {
        Intrinsics.checkNotNullParameter((Object)next, (String)"next");
        if (this.consume(amount)) {
            return next;
        }
        if (!this.getCfg().allowNegative && amount > this.getCfg().limit || !this.getCfg().awaitRegen) {
            throw new LuaException("Insufficient energy (requires " + amount + ", has " + this.value + ".");
        }
        FutureMethodResult futureMethodResult = FutureMethodResult.awaiting(() -> DefaultCostHandler.await$lambda$1(this, amount), () -> DefaultCostHandler.await$lambda$2(next));
        Intrinsics.checkNotNullExpressionValue((Object)futureMethodResult, (String)"awaiting(...)");
        return futureMethodResult;
    }

    @Override
    @NotNull
    public FutureMethodResult await(double amount, @NotNull Callable<FutureMethodResult> next) throws LuaException {
        Intrinsics.checkNotNullParameter(next, (String)"next");
        if (this.consume(amount)) {
            FutureMethodResult futureMethodResult;
            try {
                futureMethodResult = next.call();
                Intrinsics.checkNotNull((Object)futureMethodResult);
            }
            catch (Exception e) {
                if (e instanceof LuaException) {
                    throw e;
                }
                Plethora.log.error("Unexpected error", (Throwable)e);
                throw new LuaException("Java Exception Thrown: " + e);
            }
            return futureMethodResult;
        }
        if (!this.getCfg().allowNegative && amount > this.getCfg().limit || !this.getCfg().awaitRegen) {
            throw new LuaException("Insufficient energy (requires " + amount + ", has " + this.value + ").");
        }
        FutureMethodResult futureMethodResult = FutureMethodResult.awaiting(() -> DefaultCostHandler.await$lambda$3(this, amount), next);
        Intrinsics.checkNotNullExpressionValue((Object)futureMethodResult, (String)"awaiting(...)");
        return futureMethodResult;
    }

    private final synchronized void regen() {
        if (this.value < this.getCfg().limit) {
            this.value = RangesKt.coerceAtMost((double)this.getCfg().limit, (double)(this.value + this.getCfg().regen));
        }
    }

    private static final boolean await$lambda$1(DefaultCostHandler this$0, double $amount) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return this$0.consume($amount);
    }

    private static final FutureMethodResult await$lambda$2(FutureMethodResult $next) {
        Intrinsics.checkNotNullParameter((Object)$next, (String)"$next");
        return $next;
    }

    private static final boolean await$lambda$3(DefaultCostHandler this$0, double $amount) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return this$0.consume($amount);
    }

    @JvmStatic
    @NotNull
    public static final ICostHandler get(@NotNull Object owner) {
        return Companion.get(owner);
    }

    @JvmStatic
    public static final void update() {
        Companion.update();
    }

    @JvmStatic
    public static final void reset() {
        Companion.reset();
    }

    static {
        ConcurrentMap concurrentMap = new MapMaker().weakKeys().concurrencyLevel(1).makeMap();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"makeMap(...)");
        handlers = concurrentMap;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0001H\u0087\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000f\u0010\t\u001a\u00020\bH\u0007\u00a2\u0006\u0004\b\t\u0010\u0003J\u000f\u0010\n\u001a\u00020\bH\u0007\u00a2\u0006\u0004\b\n\u0010\u0003R \u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\f0\u000b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lio/sc3/plethora/core/DefaultCostHandler$Companion;", "", "<init>", "()V", "owner", "Lio/sc3/plethora/api/method/ICostHandler;", "get", "(Ljava/lang/Object;)Lio/sc3/plethora/api/method/ICostHandler;", "", "reset", "update", "", "Lio/sc3/plethora/core/DefaultCostHandler;", "handlers", "Ljava/util/Map;", "GitHub2"})
    @SourceDebugExtension(value={"SMAP\nDefaultCostHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultCostHandler.kt\nio/sc3/plethora/core/DefaultCostHandler$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,116:1\n1#2:117\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JvmStatic
        @NotNull
        public final ICostHandler get(@NotNull Object owner) {
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            Map map = handlers;
            synchronized (map) {
                boolean bl = false;
                DefaultCostHandler handler = (DefaultCostHandler)handlers.get(owner);
                if (handler == null) {
                    handler = new DefaultCostHandler();
                    handlers.put(owner, handler);
                }
                ICostHandler iCostHandler = handler;
                return iCostHandler;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JvmStatic
        public final void update() {
            Map map = handlers;
            synchronized (map) {
                boolean bl = false;
                for (DefaultCostHandler handler : handlers.values()) {
                    handler.regen();
                }
                Unit unit = Unit.INSTANCE;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JvmStatic
        public final void reset() {
            Map map = handlers;
            synchronized (map) {
                boolean bl = false;
                handlers.clear();
                Unit unit = Unit.INSTANCE;
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

