/*
 * Decompiled with CFR 0.152.
 */
package io.sc3.plethora.gameplay.modules.glasses.canvas;

import io.sc3.plethora.Plethora;
import io.sc3.plethora.api.method.IAttachable;
import io.sc3.plethora.api.module.IModuleAccess;
import io.sc3.plethora.api.reference.ConstantReference;
import io.sc3.plethora.api.reference.IReference;
import io.sc3.plethora.gameplay.modules.glasses.canvas.CanvasHandler;
import io.sc3.plethora.gameplay.modules.glasses.networking.CanvasAddPacket;
import io.sc3.plethora.gameplay.modules.glasses.networking.CanvasRemovePacket;
import io.sc3.plethora.gameplay.modules.glasses.networking.CanvasUpdatePacket;
import io.sc3.plethora.gameplay.modules.glasses.objects.BaseObject;
import io.sc3.plethora.gameplay.modules.glasses.objects.ObjectGroup;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.objects.ObjectCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\f\u0010\rJ\u000f\u0010\u000e\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0015\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0017\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0013H\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u000f\u0010\u0017\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u0017\u0010\u000fJ\u000f\u0010\u0018\u001a\u00020\u0000H\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019J#\u0010\u001d\u001a\u0004\u0018\u00018\u0000\"\n\b\u0000\u0010\u001a*\u0004\u0018\u00010\t2\u0006\u0010\u001c\u001a\u00020\u001b\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u000f\u0010 \u001a\u0004\u0018\u00010\u001f\u00a2\u0006\u0004\b \u0010!J\u000f\u0010#\u001a\u0004\u0018\u00010\"\u00a2\u0006\u0004\b#\u0010$J\u000f\u0010&\u001a\u0004\u0018\u00010%\u00a2\u0006\u0004\b&\u0010'J\r\u0010(\u001a\u00020\u001b\u00a2\u0006\u0004\b(\u0010)J%\u0010,\u001a\b\u0012\u0004\u0012\u00028\u00000+\"\b\b\u0000\u0010\u001a*\u00020\t2\u0006\u0010*\u001a\u00028\u0000\u00a2\u0006\u0004\b,\u0010-J\u0015\u0010.\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b.\u0010\rJ\u0017\u00100\u001a\u00020/2\u0006\u0010\u001c\u001a\u00020\u001bH\u0002\u00a2\u0006\u0004\b0\u00101J\u000f\u00102\u001a\u00020\u0000H\u0016\u00a2\u0006\u0004\b2\u0010\u0019R\u0014\u0010\u0004\u001a\u00020\u00038\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0004\u00103R\u0017\u00105\u001a\u0002048\u0006\u00a2\u0006\f\n\u0004\b5\u00106\u001a\u0004\b7\u00108R\u0017\u0010:\u001a\u0002098\u0006\u00a2\u0006\f\n\u0004\b:\u0010;\u001a\u0004\b<\u0010=R\u0014\u0010>\u001a\u00020\u001b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b>\u0010?R\u001a\u0010A\u001a\b\u0012\u0004\u0012\u00020\u00130@8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bA\u0010BR\u0014\u0010D\u001a\u00020C8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bD\u0010ER\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\t0@8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0014\u0010BR\u0017\u0010\u0006\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010F\u001a\u0004\bG\u0010HR\u0014\u0010I\u001a\u00020\u00138\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bI\u0010J\u00a8\u0006K"}, d2={"Lio/sc3/plethora/gameplay/modules/glasses/canvas/CanvasServer;", "Lio/sc3/plethora/api/reference/ConstantReference;", "Lio/sc3/plethora/api/method/IAttachable;", "Lio/sc3/plethora/api/module/IModuleAccess;", "access", "Lnet/minecraft/class_3222;", "player", "<init>", "(Lio/sc3/plethora/api/module/IModuleAccess;Lnet/minecraft/class_3222;)V", "Lio/sc3/plethora/gameplay/modules/glasses/objects/BaseObject;", "obj", "", "add", "(Lio/sc3/plethora/gameplay/modules/glasses/objects/BaseObject;)V", "attach", "()V", "Lio/sc3/plethora/gameplay/modules/glasses/objects/ObjectGroup;", "clear", "(Lio/sc3/plethora/gameplay/modules/glasses/objects/ObjectGroup;)V", "Lit/unimi/dsi/fastutil/ints/IntSet;", "objects", "clearImpl", "(Lit/unimi/dsi/fastutil/ints/IntSet;)V", "detach", "get", "()Lio/sc3/plethora/gameplay/modules/glasses/canvas/CanvasServer;", "T", "", "id", "getObject", "(I)Lio/sc3/plethora/gameplay/modules/glasses/objects/BaseObject;", "Lio/sc3/plethora/gameplay/modules/glasses/networking/CanvasAddPacket;", "makeAddPacket", "()Lio/sc3/plethora/gameplay/modules/glasses/networking/CanvasAddPacket;", "Lio/sc3/plethora/gameplay/modules/glasses/networking/CanvasRemovePacket;", "makeRemovePacket", "()Lio/sc3/plethora/gameplay/modules/glasses/networking/CanvasRemovePacket;", "Lio/sc3/plethora/gameplay/modules/glasses/networking/CanvasUpdatePacket;", "makeUpdatePacket", "()Lio/sc3/plethora/gameplay/modules/glasses/networking/CanvasUpdatePacket;", "newObjectId", "()I", "baseObject", "Lio/sc3/plethora/api/reference/IReference;", "reference", "(Lio/sc3/plethora/gameplay/modules/glasses/objects/BaseObject;)Lio/sc3/plethora/api/reference/IReference;", "remove", "", "removeImpl", "(I)Z", "safeGet", "Lio/sc3/plethora/api/module/IModuleAccess;", "Lio/sc3/plethora/gameplay/modules/glasses/objects/ObjectGroup$Frame2d;", "canvas2d", "Lio/sc3/plethora/gameplay/modules/glasses/objects/ObjectGroup$Frame2d;", "getCanvas2d", "()Lio/sc3/plethora/gameplay/modules/glasses/objects/ObjectGroup$Frame2d;", "Lio/sc3/plethora/gameplay/modules/glasses/objects/ObjectGroup$Origin3d;", "canvas3d", "Lio/sc3/plethora/gameplay/modules/glasses/objects/ObjectGroup$Origin3d;", "getCanvas3d", "()Lio/sc3/plethora/gameplay/modules/glasses/objects/ObjectGroup$Origin3d;", "canvasId", "I", "Lit/unimi/dsi/fastutil/ints/Int2ObjectMap;", "childrenOf", "Lit/unimi/dsi/fastutil/ints/Int2ObjectMap;", "Ljava/util/concurrent/atomic/AtomicInteger;", "lastId", "Ljava/util/concurrent/atomic/AtomicInteger;", "Lnet/minecraft/class_3222;", "getPlayer", "()Lnet/minecraft/class_3222;", "removed", "Lit/unimi/dsi/fastutil/ints/IntSet;", "GitHub2"})
@SourceDebugExtension(value={"SMAP\nCanvasServer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CanvasServer.kt\nio/sc3/plethora/gameplay/modules/glasses/canvas/CanvasServer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,159:1\n1#2:160\n*E\n"})
public final class CanvasServer
implements ConstantReference<CanvasServer>,
IAttachable {
    private final int canvasId;
    @NotNull
    private final IModuleAccess access;
    @NotNull
    private final class_3222 player;
    @NotNull
    private final Int2ObjectMap<BaseObject> objects;
    @NotNull
    private final Int2ObjectMap<IntSet> childrenOf;
    @NotNull
    private final IntSet removed;
    @NotNull
    private final AtomicInteger lastId;
    @NotNull
    private final ObjectGroup.Frame2d canvas2d;
    @NotNull
    private final ObjectGroup.Origin3d canvas3d;

    public CanvasServer(@NotNull IModuleAccess access, @NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter((Object)access, (String)"access");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        this.canvasId = CanvasHandler.INSTANCE.nextId();
        this.objects = (Int2ObjectMap)new Int2ObjectOpenHashMap();
        this.childrenOf = (Int2ObjectMap)new Int2ObjectOpenHashMap();
        this.removed = (IntSet)new IntOpenHashSet();
        this.lastId = new AtomicInteger(1);
        this.canvas2d = new ObjectGroup.Frame2d(){
            private final int id;

            public int getId() {
                return this.id;
            }

            public int getWidth() {
                return ObjectGroup.Frame2d.DefaultImpls.getWidth(this);
            }

            public int getHeight() {
                return ObjectGroup.Frame2d.DefaultImpls.getHeight(this);
            }
        };
        this.canvas3d = new ObjectGroup.Origin3d(){
            private final int id;
            {
                this.id = 1;
            }

            public int getId() {
                return this.id;
            }
        };
        this.access = access;
        this.player = player;
        this.childrenOf.put(0, (Object)new IntOpenHashSet());
        this.childrenOf.put(1, (Object)new IntOpenHashSet());
    }

    @NotNull
    public final class_3222 getPlayer() {
        return this.player;
    }

    @NotNull
    public final ObjectGroup.Frame2d getCanvas2d() {
        return this.canvas2d;
    }

    @NotNull
    public final ObjectGroup.Origin3d getCanvas3d() {
        return this.canvas3d;
    }

    @Override
    public void attach() {
        this.access.getData().method_10569("id", this.canvasId);
        this.access.markDataDirty();
        CanvasHandler.INSTANCE.addServer(this);
    }

    @Override
    public void detach() {
        CanvasHandler.INSTANCE.removeServer(this);
        this.access.getData().method_10551("id");
        this.access.markDataDirty();
    }

    public final int newObjectId() {
        return this.lastId.incrementAndGet();
    }

    @Nullable
    public final synchronized CanvasAddPacket makeAddPacket() {
        CanvasAddPacket canvasAddPacket;
        try {
            Collection collection = this.objects.values();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"<get-values>(...)");
            canvasAddPacket = new CanvasAddPacket(this.canvasId, collection);
        }
        catch (Exception e) {
            Plethora.log.error("Error while making add packet. Object list was abandoned", (Throwable)e);
            canvasAddPacket = null;
        }
        return canvasAddPacket;
    }

    @Nullable
    public final synchronized CanvasRemovePacket makeRemovePacket() {
        CanvasRemovePacket canvasRemovePacket;
        try {
            canvasRemovePacket = new CanvasRemovePacket(this.canvasId);
        }
        catch (Exception e) {
            Plethora.log.error("Error while making remove packet. Object list was abandoned", (Throwable)e);
            canvasRemovePacket = null;
        }
        return canvasRemovePacket;
    }

    @Nullable
    public final synchronized CanvasUpdatePacket makeUpdatePacket() {
        try {
            List changed = null;
            for (BaseObject obj : (ObjectCollection)this.objects.values()) {
                try {
                    BaseObject baseObject = obj;
                    Intrinsics.checkNotNull((Object)baseObject);
                    if (!baseObject.pollDirty()) continue;
                    if (changed == null) {
                        changed = new ArrayList();
                    }
                    changed.add(obj);
                }
                catch (Exception e) {
                    Plethora.log.error("Error while polling object for changes. Object was skipped", (Throwable)e);
                }
            }
            if (changed == null && this.removed.isEmpty()) {
                return null;
            }
            if (changed == null) {
                changed = new ArrayList();
            }
            int[] nArray = this.removed.toIntArray();
            Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"toIntArray(...)");
            CanvasUpdatePacket packet = new CanvasUpdatePacket(this.canvasId, changed, nArray);
            this.removed.clear();
            return packet;
        }
        catch (Exception e) {
            Plethora.log.error("Error while making update packet. Changelist was abandoned", (Throwable)e);
            return null;
        }
    }

    public final synchronized void add(@NotNull BaseObject obj) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        IntSet intSet = (IntSet)this.childrenOf.get(obj.getParent());
        if (intSet == null) {
            throw new IllegalArgumentException("No such parent");
        }
        IntSet parent = intSet;
        if (!(this.objects.put(obj.getId(), (Object)obj) == null)) {
            boolean bl = false;
            String string = "An object already exists with that key";
            throw new IllegalStateException(string.toString());
        }
        parent.add(obj.getId());
        if (obj instanceof ObjectGroup) {
            this.childrenOf.put(obj.getId(), (Object)new IntOpenHashSet());
        }
    }

    public final synchronized void remove(@NotNull BaseObject obj) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        if (!this.removeImpl(obj.getId())) {
            boolean bl = false;
            String string = "No such object with this key";
            throw new IllegalStateException(string.toString());
        }
    }

    @Nullable
    public final synchronized <T extends BaseObject> T getObject(int id) {
        return (T)((BaseObject)this.objects.get(id));
    }

    public final synchronized void clear(@NotNull ObjectGroup obj) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        IntSet intSet = (IntSet)this.childrenOf.get(obj.getId());
        if (intSet == null) {
            throw new IllegalStateException("Object has no children");
        }
        IntSet children = intSet;
        this.clearImpl(children);
    }

    private final boolean removeImpl(int id) {
        IntSet children;
        if (this.objects.remove(id) == null) {
            return false;
        }
        IntSet intSet = children = (IntSet)this.childrenOf.remove(id);
        if (intSet != null) {
            IntSet it = intSet;
            boolean bl = false;
            this.clearImpl(it);
        }
        this.removed.add(id);
        return true;
    }

    private final void clearImpl(IntSet objects) {
        IntIterator intIterator = objects.iterator();
        Intrinsics.checkNotNullExpressionValue((Object)intIterator, (String)"iterator(...)");
        IntIterator iterator = intIterator;
        while (iterator.hasNext()) {
            int childId = iterator.nextInt();
            this.removeImpl(childId);
            iterator.remove();
        }
    }

    @Override
    @NotNull
    public CanvasServer get() {
        return this;
    }

    @Override
    @NotNull
    public CanvasServer safeGet() {
        return this;
    }

    @NotNull
    public final <T extends BaseObject> IReference<T> reference(@NotNull T baseObject) {
        Intrinsics.checkNotNullParameter(baseObject, (String)"baseObject");
        return new BaseObject.BaseObjectReference(this, baseObject);
    }
}

