/*
 * Decompiled with CFR 0.152.
 */
package io.sc3.plethora.gameplay.modules.laser;

import com.mojang.authlib.GameProfile;
import io.sc3.plethora.Plethora;
import io.sc3.plethora.api.IPlayerOwnable;
import io.sc3.plethora.gameplay.PlethoraBlockTags;
import io.sc3.plethora.gameplay.PlethoraEntityTags;
import io.sc3.plethora.gameplay.PlethoraFakePlayer;
import io.sc3.plethora.gameplay.registry.Registration;
import io.sc3.plethora.mixin.TntBlockInvoker;
import io.sc3.plethora.util.PlayerHelpers;
import io.sc3.plethora.util.WorldPosition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nonnull;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerEntityEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_2404;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_5321;
import net.minecraft.class_5552;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0006\n\u0002\b\u0012\n\u0002\u0010\b\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\b\u0018\u0000 ]2\u00020\u00012\u00020\u0002:\u0001]B!\b\u0016\u0012\u000e\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00000\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bB+\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0001\u0010\t\u001a\u00020\u0001\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\f\u001a\u00020\n\u00a2\u0006\u0004\b\u0007\u0010\rB\u0019\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0004\b\u0007\u0010\u0010J/\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0015H\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0017\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u0001H\u0002\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0011\u0010\u001d\u001a\u0004\u0018\u00010\u001cH\u0016\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0011\u0010\u001f\u001a\u0004\u0018\u00010\u0001H\u0002\u00a2\u0006\u0004\b\u001f\u0010 J\u0011\u0010!\u001a\u0004\u0018\u00010\u0015H\u0002\u00a2\u0006\u0004\b!\u0010\"J\u000f\u0010$\u001a\u00020#H\u0014\u00a2\u0006\u0004\b$\u0010%J\u0017\u0010(\u001a\u00020#2\u0006\u0010'\u001a\u00020&H\u0002\u00a2\u0006\u0004\b(\u0010)J\u0017\u0010,\u001a\u00020#2\u0006\u0010+\u001a\u00020*H\u0016\u00a2\u0006\u0004\b,\u0010-J!\u0010/\u001a\u00020#2\b\u0010\t\u001a\u0004\u0018\u00010\u00012\b\u0010.\u001a\u0004\u0018\u00010\u001c\u00a2\u0006\u0004\b/\u00100J'\u00105\u001a\u00020#2\u0006\u00102\u001a\u0002012\u0006\u00103\u001a\u0002012\u0006\u00104\u001a\u000201H\u0016\u00a2\u0006\u0004\b5\u00106J5\u0010;\u001a\u00020#2\u0006\u00107\u001a\u0002012\u0006\u00108\u001a\u0002012\u0006\u00109\u001a\u0002012\u0006\u0010:\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b;\u0010<J\u0017\u0010>\u001a\u00020#2\u0006\u0010=\u001a\u00020\u0013H\u0002\u00a2\u0006\u0004\b>\u0010?J\u000f\u0010@\u001a\u00020#H\u0016\u00a2\u0006\u0004\b@\u0010%J/\u0010A\u001a\u00020\u00132\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0015H\u0002\u00a2\u0006\u0004\bA\u0010\u0018JG\u0010G\u001a\u00020#2\u0006\u00102\u001a\u0002012\u0006\u00103\u001a\u0002012\u0006\u00104\u001a\u0002012\u0006\u0010B\u001a\u00020\n2\u0006\u0010C\u001a\u00020\n2\u0006\u0010E\u001a\u00020D2\u0006\u0010F\u001a\u00020\u0013H\u0016\u00a2\u0006\u0004\bG\u0010HJ\u0017\u0010I\u001a\u00020#2\u0006\u0010+\u001a\u00020*H\u0016\u00a2\u0006\u0004\bI\u0010-R\"\u0010\f\u001a\u00020\n8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\f\u0010J\u001a\u0004\bK\u0010L\"\u0004\bM\u0010NR\u0018\u0010\t\u001a\u0004\u0018\u00010\u00018\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\t\u0010OR\u0018\u0010P\u001a\u0004\u0018\u00010\u001c8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bP\u0010QR\u0018\u0010R\u001a\u0004\u0018\u00010\u00158\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bR\u0010SR\u0018\u0010\u000f\u001a\u0004\u0018\u00010T8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u000f\u0010UR\"\u0010W\u001a\u00020V8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bW\u0010X\u001a\u0004\bY\u0010Z\"\u0004\b[\u0010\\\u00a8\u0006^"}, d2={"Lio/sc3/plethora/gameplay/modules/laser/LaserEntity;", "Lnet/minecraft/class_1297;", "Lio/sc3/plethora/api/IPlayerOwnable;", "Lnet/minecraft/class_1299;", "entityType", "Lnet/minecraft/class_1937;", "world", "<init>", "(Lnet/minecraft/class_1299;Lnet/minecraft/class_1937;)V", "shooter", "", "inaccuracy", "potency", "(Lnet/minecraft/class_1937;Lnet/minecraft/class_1297;FF)V", "Lnet/minecraft/class_243;", "shooterPos", "(Lnet/minecraft/class_1937;Lnet/minecraft/class_243;)V", "Lnet/minecraft/class_2338;", "pos", "", "drop", "Lnet/minecraft/class_1657;", "player", "canBreakBlock", "(Lnet/minecraft/class_1937;Lnet/minecraft/class_2338;ZLnet/minecraft/class_1657;)Z", "entity", "canDamageEntity", "(Lnet/minecraft/class_1297;)Z", "Lcom/mojang/authlib/GameProfile;", "getOwningProfile", "()Lcom/mojang/authlib/GameProfile;", "getShooter", "()Lnet/minecraft/class_1297;", "getShooterPlayer", "()Lnet/minecraft/class_1657;", "", "initDataTracker", "()V", "Lnet/minecraft/class_239;", "hitResult", "onImpact", "(Lnet/minecraft/class_239;)V", "Lnet/minecraft/class_2487;", "nbt", "readCustomDataFromNbt", "(Lnet/minecraft/class_2487;)V", "profile", "setShooter", "(Lnet/minecraft/class_1297;Lcom/mojang/authlib/GameProfile;)V", "", "x", "y", "z", "setVelocityClient", "(DDD)V", "vx", "vy", "vz", "velocity", "shoot", "(DDDFF)V", "force", "syncPositions", "(Z)V", "tick", "tryBreakBlock", "yaw", "pitch", "", "interpolationSteps", "interpolate", "updateTrackedPositionAndAngles", "(DDDFFIZ)V", "writeCustomDataToNbt", "F", "getPotency", "()F", "setPotency", "(F)V", "Lnet/minecraft/class_1297;", "shooterOwner", "Lcom/mojang/authlib/GameProfile;", "shooterPlayer", "Lnet/minecraft/class_1657;", "Lio/sc3/plethora/util/WorldPosition;", "Lio/sc3/plethora/util/WorldPosition;", "", "spawnTime", "J", "getSpawnTime", "()J", "setSpawnTime", "(J)V", "Companion", "GitHub2"})
@SourceDebugExtension(value={"SMAP\nLaserEntity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LaserEntity.kt\nio/sc3/plethora/gameplay/modules/laser/LaserEntity\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,487:1\n1#2:488\n*E\n"})
public final class LaserEntity
extends class_1297
implements IPlayerOwnable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private class_1297 shooter;
    @Nullable
    private class_1657 shooterPlayer;
    @Nullable
    private GameProfile shooterOwner;
    @Nullable
    private WorldPosition shooterPos;
    private float potency;
    private long spawnTime;
    @NotNull
    private static final Random rand = new Random();
    private static final int lifetime = Plethora.config.laser.lifetime;
    @NotNull
    private static final Set<LaserEntity> trackedLasers = new LinkedHashSet();
    private static final int laserCleanupInterval = lifetime * 2;

    public final float getPotency() {
        return this.potency;
    }

    public final void setPotency(float f) {
        this.potency = f;
    }

    public final long getSpawnTime() {
        return this.spawnTime;
    }

    public final void setSpawnTime(long l) {
        this.spawnTime = l;
    }

    public LaserEntity(@NotNull class_1299<? extends LaserEntity> entityType, @NotNull class_1937 world) {
        Intrinsics.checkNotNullParameter(entityType, (String)"entityType");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        super(entityType, world);
        this.spawnTime = this.method_37908().method_8510();
    }

    public LaserEntity(@NotNull class_1937 world, @Nonnull @NotNull class_1297 shooter, float inaccuracy, float potency) {
        class_243 class_2432;
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)shooter, (String)"shooter");
        super(Registration.LASER_ENTITY, world);
        this.spawnTime = this.method_37908().method_8510();
        this.potency = potency;
        this.setShooter(shooter, PlayerHelpers.getProfile(shooter));
        double yaw = shooter.method_36454();
        float pitch = shooter.method_36455();
        class_243 pos = shooter.method_33571();
        this.method_33574(pos.method_1023(Math.cos(yaw / 180.0 * Math.PI) * 0.16, 0.1, Math.sin(yaw / 180.0 * Math.PI) * 0.16));
        class_243 it = class_2432 = new class_243(-Math.sin(yaw / 180.0 * Math.PI) * Math.cos((double)pitch / 180.0 * Math.PI), -Math.sin((double)pitch / 180.0 * Math.PI), Math.cos(yaw / 180.0 * Math.PI) * Math.cos((double)pitch / 180.0 * Math.PI));
        boolean bl = false;
        this.method_18799(it);
        class_243 vel = class_2432;
        this.shoot(vel.field_1352, vel.field_1351, vel.field_1350, 1.5f, inaccuracy);
    }

    public LaserEntity(@NotNull class_1937 world, @NotNull class_243 shooterPos) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)shooterPos, (String)"shooterPos");
        class_1299<LaserEntity> class_12992 = Registration.LASER_ENTITY;
        Intrinsics.checkNotNullExpressionValue(class_12992, (String)"LASER_ENTITY");
        this(class_12992, world);
        this.shooterPos = new WorldPosition(world, shooterPos);
    }

    public final void setShooter(@Nullable class_1297 shooter, @Nullable GameProfile profile) {
        this.shooter = shooter;
        this.shooterOwner = profile;
    }

    protected void method_5693() {
    }

    public final void shoot(double vx, double vy, double vz, float velocity, float inaccuracy) {
        class_243 vec3d = new class_243(vx, vy, vz).method_1029().method_1031(this.field_5974.method_43059() * 0.0075 * (double)inaccuracy, this.field_5974.method_43059() * 0.0075 * (double)inaccuracy, this.field_5974.method_43059() * 0.0075 * (double)inaccuracy).method_1021((double)velocity);
        this.method_18799(vec3d);
        this.method_36456((float)(class_3532.method_15349((double)vec3d.field_1352, (double)vec3d.field_1350) * (double)180 / Math.PI));
        this.method_36457((float)(class_3532.method_15349((double)vec3d.field_1351, (double)vec3d.method_37267()) * (double)180 / Math.PI));
        this.field_5982 = this.method_36454();
        this.field_6004 = this.method_36455();
    }

    public void method_5759(double x, double y, double z, float yaw, float pitch, int interpolationSteps, boolean interpolate) {
        this.method_5814(x, y, z);
        this.method_5710(yaw, pitch);
    }

    public void method_5750(double x, double y, double z) {
        this.method_18800(x, y, z);
        if (this.field_6004 == 0.0f && this.field_5982 == 0.0f) {
            this.method_36457((float)(class_3532.method_15349((double)y, (double)Math.sqrt(x * x + z * z)) * (double)180 / Math.PI));
            this.method_36456((float)(class_3532.method_15349((double)x, (double)z) * (double)180 / Math.PI));
            this.field_6004 = this.method_36455();
            this.field_5982 = this.method_36454();
            this.method_5808(this.method_23317(), this.method_23318(), this.method_23321(), this.method_36454(), this.method_36455());
        }
    }

    public void method_5652(@NotNull class_2487 nbt) {
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        PlayerHelpers.writeProfile(nbt, this.shooterOwner);
        WorldPosition worldPosition = this.shooterPos;
        if (worldPosition != null) {
            WorldPosition it = worldPosition;
            boolean bl = false;
            nbt.method_10566("shooterPos", (class_2520)it.serializeNbt());
        }
        nbt.method_10548("potency", this.potency);
        nbt.method_10544("spawn", this.spawnTime);
    }

    public void method_5749(@NotNull class_2487 nbt) {
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        this.shooter = null;
        this.shooterPlayer = null;
        this.shooterOwner = PlayerHelpers.readProfile(nbt);
        if (nbt.method_10573("shooterPos", 10)) {
            this.shooterPos = WorldPosition.deserializeNbt(nbt.method_10562("shooterPos"));
        }
        this.potency = nbt.method_10583("potency");
        this.spawnTime = nbt.method_10537("spawn");
    }

    public void method_5773() {
        class_1937 world = this.method_37908();
        this.field_6014 = this.method_23317();
        this.field_6036 = this.method_23318();
        this.field_5969 = this.method_23321();
        super.method_5773();
        if (!world.field_9236) {
            class_243 vel;
            class_243 nextPos;
            class_243 pos;
            int ticks = 5;
            for (double remaining = 1.0; remaining >= 0.01 && this.potency > 0.0f && --ticks >= 0; remaining -= pos.method_1022(nextPos) / Math.sqrt(vel.method_1027())) {
                pos = this.method_19538();
                vel = this.method_18798();
                nextPos = new class_243(pos.field_1352 + vel.field_1352 * remaining, pos.field_1351 + vel.field_1351 * remaining, pos.field_1350 + vel.field_1350 * remaining);
                class_239 collision = (class_239)world.method_17742(new class_3959(pos, nextPos, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)this));
                if (collision != null && collision.method_17783() != class_239.class_240.field_1333) {
                    class_243 class_2432 = collision.method_17784();
                    Intrinsics.checkNotNullExpressionValue((Object)class_2432, (String)"getPos(...)");
                    nextPos = class_2432;
                }
                List collisions = world.method_8335((class_1297)this, this.method_5829().method_989(vel.field_1352 * remaining, vel.field_1351 * remaining, vel.field_1350 * remaining).method_1014(1.0));
                class_1297 shooter = this.getShooter();
                double closestDistance = nextPos.method_1025(pos);
                class_1309 closestEntity = null;
                for (class_1297 other : collisions) {
                    if (Intrinsics.areEqual((Object)other, (Object)shooter) && this.field_6012 < 5 || !(other instanceof class_1309) || other instanceof class_1657 && shooter instanceof class_1657 && !((class_1657)shooter).method_7256((class_1657)other)) continue;
                    float size = 0.3f;
                    class_238 singleCollision = other.method_5829().method_1014((double)size);
                    Optional optional = singleCollision.method_992(pos, nextPos);
                    if (!optional.isPresent()) continue;
                    Object t = optional.get();
                    Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
                    class_243 hit = (class_243)t;
                    double distanceSq = hit.method_1025(pos);
                    if (!(distanceSq < closestDistance)) continue;
                    closestEntity = (class_1309)other;
                    closestDistance = distanceSq;
                    nextPos = hit;
                }
                if (closestEntity != null) {
                    collision = (class_239)new class_3966((class_1297)closestEntity);
                }
                this.method_33574(nextPos);
                if (collision == null || collision.method_17783() == class_239.class_240.field_1333) continue;
                class_2338 blockPos = class_2338.method_49638((class_2374)((class_2374)collision.method_17784()));
                if (collision.method_17783() == class_239.class_240.field_1332 && world.method_8320(blockPos).method_27852(class_2246.field_10316)) {
                    this.method_5717(blockPos);
                    continue;
                }
                this.onImpact(collision);
            }
        } else {
            class_243 vel = this.method_18798();
            class_243 newPos = this.method_19538().method_1019(vel);
            this.method_33574(newPos);
        }
        if (!world.field_9236 && (this.potency <= 0.0f || this.field_6012 > lifetime)) {
            this.method_5768();
        }
    }

    private final void onImpact(class_239 hitResult) {
        if (this.method_37908().field_9236) {
            return;
        }
        class_1937 class_19372 = this.method_37908();
        class_3218 class_32182 = class_19372 instanceof class_3218 ? (class_3218)class_19372 : null;
        if (class_32182 == null) {
            return;
        }
        class_3218 world = class_32182;
        if (hitResult.method_17783() == class_239.class_240.field_1332) {
            if (!(hitResult instanceof class_3965)) {
                return;
            }
            class_2338 position = class_2338.method_49638((class_2374)((class_2374)hitResult.method_17784()));
            class_2680 blockState = world.method_8320(position);
            class_2248 block = blockState.method_26204();
            if (!blockState.method_26215() && !(blockState.method_26204() instanceof class_2404)) {
                float hardness = blockState.method_26214((class_1922)world, position);
                class_1657 class_16572 = this.getShooterPlayer();
                if (class_16572 == null) {
                    return;
                }
                class_1657 player = class_16572;
                this.syncPositions(true);
                class_1937 class_19373 = (class_1937)world;
                Intrinsics.checkNotNull((Object)position);
                if (!this.canBreakBlock(class_19373, position, false, player)) {
                    this.potency = -1.0f;
                    return;
                }
                if (block == class_2246.field_10375) {
                    this.potency -= hardness;
                    TntBlockInvoker.invokePrimeTnt((class_1937)world, position, (class_1309)player);
                    world.method_8650(position, false);
                } else if (block == class_2246.field_10540) {
                    this.potency -= hardness;
                    class_2338 offset = position.method_10093(((class_3965)hitResult).method_17780());
                    class_2680 offsetState = world.method_8320(offset);
                    if (!offsetState.method_26215()) {
                        return;
                    }
                    class_1937 class_19374 = (class_1937)world;
                    Intrinsics.checkNotNull((Object)offset);
                    if (this.canBreakBlock(class_19374, offset, false, player)) {
                        world.method_8396(null, offset, class_3417.field_15145, class_3419.field_15245, 1.0f, rand.nextFloat() * 0.4f + 0.8f);
                        world.method_8501(offset, class_2246.field_10036.method_9564());
                    }
                } else if (hardness > -1.0f && hardness <= this.potency) {
                    this.potency -= hardness;
                    if (this.canBreakBlock((class_1937)world, position, false, player) && !(block instanceof class_5552)) {
                        class_2586 blockEntity = world.method_8321(position);
                        block.method_9576((class_1937)world, position, blockState, player);
                        boolean broken = this.tryBreakBlock((class_1937)world, position, false, player);
                        if (broken) {
                            block.method_9585((class_1936)world, position, blockState);
                            if (!player.method_7337() && !class_7923.field_41175.method_47983((Object)block).method_40220(PlethoraBlockTags.INSTANCE.getLASER_DONT_DROP())) {
                                class_2248.method_9511((class_2680)blockState, (class_1937)((class_1937)world), (class_2338)position, (class_2586)blockEntity, (class_1297)((class_1297)player), (class_1799)class_1799.field_8037);
                            }
                        }
                    }
                } else {
                    this.potency = -1.0f;
                }
            }
        } else if (hitResult.method_17783() == class_239.class_240.field_1331) {
            if (!(hitResult instanceof class_3966)) {
                return;
            }
            class_1297 class_12972 = ((class_3966)hitResult).method_17782();
            Intrinsics.checkNotNullExpressionValue((Object)class_12972, (String)"getEntity(...)");
            class_1297 entity = class_12972;
            if (entity instanceof class_1309 && this.canDamageEntity(entity)) {
                this.syncPositions(true);
                class_1297 shooter = this.getShooter();
                if (((class_1309)entity).method_5864().method_20210(PlethoraEntityTags.INSTANCE.getLASERS_PROVIDE_ENERGY())) {
                    class_1293 effect = new class_1293(class_1294.field_5910, (int)((float)20 * this.potency));
                    ((class_1309)entity).method_37222(effect, shooter);
                    ((class_1309)entity).method_6025((float)((double)this.potency * Plethora.config.laser.damage));
                } else {
                    class_6880.class_6883 damageType = world.method_30349().method_30530(class_7924.field_42534).method_40290(Registration.ModDamageSources.LASER);
                    class_1282 source = new class_1282((class_6880)damageType, (class_1297)this, shooter);
                    entity.method_20803(5);
                    entity.method_5643(source, (float)((double)this.potency * Plethora.config.laser.damage));
                }
                this.potency = -1.0f;
            }
        }
    }

    private final class_1297 getShooter() {
        PlethoraFakePlayer plethoraFakePlayer;
        if (this.shooter != null) {
            return this.shooter;
        }
        class_1937 class_19372 = this.method_37908();
        class_3218 class_32182 = class_19372 instanceof class_3218 ? (class_3218)class_19372 : null;
        if (class_32182 == null) {
            return null;
        }
        class_3218 world = class_32182;
        PlethoraFakePlayer it = plethoraFakePlayer = new PlethoraFakePlayer(world, null, this.shooterOwner);
        boolean bl = false;
        this.shooterPlayer = (class_1657)it;
        this.shooter = (class_1297)it;
        return (class_1297)plethoraFakePlayer;
    }

    private final class_1657 getShooterPlayer() {
        PlethoraFakePlayer plethoraFakePlayer;
        if (this.shooterPlayer != null) {
            return this.shooterPlayer;
        }
        class_1297 shooter = this.getShooter();
        if (shooter instanceof class_1657) {
            class_1297 class_12972 = shooter;
            class_1657 it = (class_1657)class_12972;
            boolean bl = false;
            this.shooterPlayer = it;
            return (class_1657)class_12972;
        }
        class_1937 bl = this.method_37908();
        class_3218 class_32182 = bl instanceof class_3218 ? (class_3218)bl : null;
        if (class_32182 == null) {
            return null;
        }
        class_3218 world = class_32182;
        PlethoraFakePlayer it = plethoraFakePlayer = new PlethoraFakePlayer(world, shooter, this.shooterOwner);
        boolean bl2 = false;
        this.shooterPlayer = (class_1657)it;
        return (class_1657)plethoraFakePlayer;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void syncPositions(boolean force) {
        class_1937 replace;
        class_1657 class_16572 = this.shooterPlayer;
        if (!(class_16572 instanceof PlethoraFakePlayer)) return;
        PlethoraFakePlayer plethoraFakePlayer = (PlethoraFakePlayer)class_16572;
        if (plethoraFakePlayer == null) {
            return;
        }
        PlethoraFakePlayer fakePlayer = plethoraFakePlayer;
        class_1297 shooter = this.shooter;
        if (shooter != null && shooter != fakePlayer) {
            LaserEntity.Companion.syncFromEntity((class_1657)fakePlayer, shooter);
            return;
        }
        if (this.shooterPos == null) {
            LaserEntity.Companion.syncFromEntity((class_1657)fakePlayer, this);
            return;
        }
        class_1937 current = fakePlayer.method_5770();
        if (current != null) {
            class_5321 class_53212 = current.method_27983();
            WorldPosition worldPosition = this.shooterPos;
            Intrinsics.checkNotNull((Object)worldPosition);
            if (Intrinsics.areEqual((Object)class_53212, worldPosition.getWorldKey())) {
                class_1657 class_16573 = (class_1657)fakePlayer;
                WorldPosition worldPosition2 = this.shooterPos;
                Intrinsics.checkNotNull((Object)worldPosition2);
                class_243 class_2432 = worldPosition2.getPos();
                Intrinsics.checkNotNullExpressionValue((Object)class_2432, (String)"getPos(...)");
                LaserEntity.Companion.syncFromPos(class_16573, current, class_2432, this.method_36454(), this.method_36455());
                return;
            }
        }
        if (force) {
            WorldPosition worldPosition = this.shooterPos;
            Intrinsics.checkNotNull((Object)worldPosition);
            v7 = worldPosition.getWorld(this.method_5770().method_8503());
        } else {
            WorldPosition worldPosition = this.shooterPos;
            Intrinsics.checkNotNull((Object)worldPosition);
            v7 = replace = worldPosition.getWorld();
        }
        if (replace == null) {
            LaserEntity.Companion.syncFromEntity((class_1657)fakePlayer, this);
            return;
        }
        class_1657 class_16574 = (class_1657)fakePlayer;
        WorldPosition worldPosition = this.shooterPos;
        Intrinsics.checkNotNull((Object)worldPosition);
        class_243 class_2433 = worldPosition.getPos();
        Intrinsics.checkNotNullExpressionValue((Object)class_2433, (String)"getPos(...)");
        LaserEntity.Companion.syncFromPos(class_16574, replace, class_2433, this.method_36454(), this.method_36455());
    }

    @Override
    @Nullable
    public GameProfile getOwningProfile() {
        return this.shooterOwner;
    }

    private final boolean canBreakBlock(class_1937 world, class_2338 pos, boolean drop, class_1657 player) {
        return world.method_8505(player, pos);
    }

    private final boolean tryBreakBlock(class_1937 world, class_2338 pos, boolean drop, class_1657 player) {
        return world.method_8651(pos, drop, (class_1297)player);
    }

    private final boolean canDamageEntity(class_1297 entity) {
        return true;
    }

    @JvmStatic
    public static final void initLaserTracker() {
        Companion.initLaserTracker();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ1\u0010\u0010\u001a\u0016\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f\u0018\u00010\f2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u000f\u0010\u0012\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b\u0012\u0010\u0003J\u001f\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0015H\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018J9\u0010 \u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u00132\b\b\u0001\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020\u001dH\u0002\u00a2\u0006\u0004\b \u0010!R\u0014\u0010\"\u001a\u00020\u000f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\"\u0010#R\u0014\u0010$\u001a\u00020\u000f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b$\u0010#R\u0014\u0010&\u001a\u00020%8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b&\u0010'R\u001a\u0010)\u001a\b\u0012\u0004\u0012\u00020\n0(8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b)\u0010*\u00a8\u0006+"}, d2={"Lio/sc3/plethora/gameplay/modules/laser/LaserEntity$Companion;", "", "<init>", "()V", "", "expireThreshold", "", "cleanupLasers", "(J)V", "", "Lio/sc3/plethora/gameplay/modules/laser/LaserEntity;", "lasers", "Lkotlin/Triple;", "Lnet/minecraft/class_2960;", "Lnet/minecraft/class_1923;", "", "findWorstLaserChunk", "(Ljava/util/List;)Lkotlin/Triple;", "initLaserTracker", "Lnet/minecraft/class_1657;", "player", "Lnet/minecraft/class_1297;", "from", "syncFromEntity", "(Lnet/minecraft/class_1657;Lnet/minecraft/class_1297;)V", "Lnet/minecraft/class_1937;", "world", "Lnet/minecraft/class_243;", "pos", "", "yaw", "pitch", "syncFromPos", "(Lnet/minecraft/class_1657;Lnet/minecraft/class_1937;Lnet/minecraft/class_243;FF)V", "laserCleanupInterval", "I", "lifetime", "Ljava/util/Random;", "rand", "Ljava/util/Random;", "", "trackedLasers", "Ljava/util/Set;", "GitHub2"})
    @SourceDebugExtension(value={"SMAP\nLaserEntity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LaserEntity.kt\nio/sc3/plethora/gameplay/modules/laser/LaserEntity$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,487:1\n766#2:488\n857#2,2:489\n1855#2,2:492\n1477#2:494\n1502#2,3:495\n1505#2,3:505\n1#3:491\n372#4,7:498\n*S KotlinDebug\n*F\n+ 1 LaserEntity.kt\nio/sc3/plethora/gameplay/modules/laser/LaserEntity$Companion\n*L\n469#1:488\n469#1:489,2\n476#1:492,2\n481#1:494\n481#1:495,3\n481#1:505,3\n481#1:498,7\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final void syncFromEntity(class_1657 player, class_1297 from) {
            class_243 fromPos = from.method_19538();
            class_1937 fromWorld = from.method_5770();
            if (!Intrinsics.areEqual((Object)player.method_37908(), (Object)fromWorld) && fromWorld instanceof class_3218) {
                player.method_5731((class_3218)fromWorld);
            }
            player.method_5641(fromPos.field_1352, fromPos.field_1351, fromPos.field_1350, from.method_36454(), from.method_36455());
        }

        private final void syncFromPos(class_1657 player, @Nonnull class_1937 world, class_243 pos, float yaw, float pitch) {
            if (!Intrinsics.areEqual((Object)player.method_37908(), (Object)world) && world instanceof class_3218) {
                player.method_5731((class_3218)world);
            }
            player.method_5641(pos.field_1352, pos.field_1351, pos.field_1350, yaw, pitch);
        }

        @JvmStatic
        public final void initLaserTracker() {
            ServerEntityEvents.ENTITY_LOAD.register(Companion::initLaserTracker$lambda$0);
            ServerEntityEvents.ENTITY_UNLOAD.register(Companion::initLaserTracker$lambda$1);
            ServerTickEvents.END_SERVER_TICK.register(Companion::initLaserTracker$lambda$2);
        }

        /*
         * WARNING - void declaration
         */
        private final void cleanupLasers(long expireThreshold) {
            block4: {
                Object object;
                List toRemove;
                block6: {
                    block5: {
                        void $this$filterTo$iv$iv;
                        Iterable $this$filter$iv = trackedLasers;
                        boolean $i$f$filter = false;
                        Iterable iterable = $this$filter$iv;
                        Collection destination$iv$iv = new ArrayList();
                        boolean $i$f$filterTo = false;
                        for (Object element$iv$iv : $this$filterTo$iv$iv) {
                            LaserEntity it = (LaserEntity)element$iv$iv;
                            boolean bl = false;
                            if (!(it.getSpawnTime() < expireThreshold)) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        toRemove = (List)destination$iv$iv;
                        if (!(!((Collection)toRemove).isEmpty())) break block4;
                        Triple<class_2960, class_1923, Integer> worstChunk = toRemove.size() > 10 ? this.findWorstLaserChunk(toRemove) : null;
                        object = worstChunk;
                        if (object == null) break block5;
                        Triple<class_2960, class_1923, Integer> triple = object;
                        boolean bl = false;
                        class_2960 world = (class_2960)triple.component1();
                        class_1923 pos = (class_1923)triple.component2();
                        int count = ((Number)triple.component3()).intValue();
                        String string = " (" + count + " in chunk " + pos + " in " + world + ")";
                        object = string;
                        if (string != null) break block6;
                    }
                    object = "";
                }
                Object worstChunkStr = object;
                Plethora.log.info("Removing {} expired lasers{}", (Object)toRemove.size(), worstChunkStr);
                Iterable $this$forEach$iv = toRemove;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    LaserEntity it = (LaserEntity)element$iv;
                    boolean bl = false;
                    it.method_5768();
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        private final Triple<class_2960, class_1923, Integer> findWorstLaserChunk(List<LaserEntity> lasers) {
            Iterator iterator;
            void $this$groupByTo$iv$iv;
            Iterable $this$groupBy$iv = lasers;
            boolean $i$f$groupBy = false;
            Iterable iterable = $this$groupBy$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                Object object;
                LaserEntity it = (LaserEntity)element$iv$iv;
                boolean bl = false;
                Pair key$iv$iv = new Pair((Object)it.method_37908().method_27983().method_29177(), (Object)it.method_31476());
                Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl2 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object = answer$iv$iv$iv;
                } else {
                    object = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object;
                list$iv$iv.add(element$iv$iv);
            }
            Map laserChunks = destination$iv$iv;
            Iterable iterable2 = laserChunks.entrySet();
            Iterator iterator2 = iterable2.iterator();
            if (!iterator2.hasNext()) {
                iterator = null;
            } else {
                Iterator iterator3 = iterator2.next();
                if (!iterator2.hasNext()) {
                    iterator = iterator3;
                } else {
                    Map.Entry it = (Map.Entry)((Object)iterator3);
                    boolean bl = false;
                    int n = ((List)it.getValue()).size();
                    do {
                        Object t = iterator2.next();
                        Map.Entry it2 = (Map.Entry)t;
                        $i$a$-maxByOrNull-LaserEntity$Companion$findWorstLaserChunk$worst$1 = false;
                        int n2 = ((List)it2.getValue()).size();
                        if (n >= n2) continue;
                        iterator3 = t;
                        n = n2;
                    } while (iterator2.hasNext());
                    iterator = iterator3;
                }
            }
            Map.Entry entry = (Map.Entry)((Object)iterator);
            if (entry == null) {
                return null;
            }
            Map.Entry worst = entry;
            return new Triple(((Pair)worst.getKey()).getFirst(), ((Pair)worst.getKey()).getSecond(), (Object)((List)worst.getValue()).size());
        }

        private static final void initLaserTracker$lambda$0(class_1297 entity, class_3218 class_32182) {
            if (entity instanceof LaserEntity) {
                trackedLasers.add(entity);
            }
        }

        private static final void initLaserTracker$lambda$1(class_1297 entity, class_3218 class_32182) {
            if (entity instanceof LaserEntity) {
                trackedLasers.remove(entity);
            }
        }

        private static final void initLaserTracker$lambda$2(MinecraftServer server) {
            long time = server.method_30002().method_8510();
            if (time % (long)laserCleanupInterval == 0L) {
                Companion.cleanupLasers(time - (long)lifetime);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

