/*
 * Decompiled with CFR 0.152.
 */
package cc.reconnected.pronouns;

import cc.reconnected.server.api.PlayerMeta;
import eu.pb4.placeholders.api.PlaceholderResult;
import eu.pb4.placeholders.api.Placeholders;
import java.util.Objects;
import java.util.UUID;
import java.util.regex.Pattern;
import net.minecraft.class_2168;
import net.minecraft.class_2960;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Pronouns {
    static MinecraftServer server;
    static Logger LOGGER;

    public static void onServerStart(MinecraftServer server) {
        Pronouns.server = server;
        Placeholders.register((class_2960)new class_2960("rcc-pronouns", "pronoun1"), (ctx, arg) -> {
            String pronouns = Pronouns.getPronouns(ctx.player().method_5667());
            if (pronouns.isBlank()) {
                return PlaceholderResult.value((String)"");
            }
            return PlaceholderResult.value((String)pronouns.split("(\\s|,|/)", 2)[0]);
        });
        Placeholders.register((class_2960)new class_2960("rcc-pronouns", "pronoun2"), (ctx, arg) -> {
            String pronouns = Pronouns.getPronouns(ctx.player().method_5667());
            if (pronouns.isBlank()) {
                return PlaceholderResult.value((String)"");
            }
            return PlaceholderResult.value((String)pronouns.split("(\\s|,|/)", 2)[1]);
        });
    }

    public static Boolean validatePronoun(String pronoun) {
        return Pattern.matches("^(he|him|she|her|it|its|they|them|any|ask|avoid|other)$", pronoun.toLowerCase());
    }

    public static String setPronouns(class_2168 player, String pronoun) {
        if (!player.method_43737()) {
            return "This command can only be run by a player.";
        }
        if (Objects.equals(pronoun.toLowerCase(), "clear")) {
            PlayerMeta pData = PlayerMeta.getPlayer((UUID)Objects.requireNonNull(player.method_44023()).method_5667());
            pData.set("pronouns", "").join();
            return "Cleared Pronouns.";
        }
        if (!Pronouns.validatePronoun(pronoun).booleanValue()) {
            return "Invalid pronouns.";
        }
        PlayerMeta pData = PlayerMeta.getPlayer((UUID)Objects.requireNonNull(player.method_44023()).method_5667());
        pData.delete("pronouns").join();
        pData.set("pronouns", pronoun.toLowerCase() + ",").join();
        return "Changed Pronouns";
    }

    public static String setPronouns(class_2168 player, String pronoun1, String pronoun2) {
        if (!player.method_43737()) {
            return "This command can only be run by a player.";
        }
        if (!Pronouns.validatePronoun(pronoun1).booleanValue() || !Pronouns.validatePronoun(pronoun2).booleanValue()) {
            return "Invalid pronouns.";
        }
        PlayerMeta pData = PlayerMeta.getPlayer((UUID)Objects.requireNonNull(player.method_44023()).method_5667());
        try {
            pData.delete("pronouns").join();
            pData.set("pronouns", pronoun1.toLowerCase() + "/" + pronoun2.toLowerCase()).join();
        }
        catch (Exception e) {
            LOGGER.error("Error setting pronouns", (Throwable)e);
            return "Error setting pronouns";
        }
        return "Changed Pronouns";
    }

    public static String getPronouns(UUID player) {
        PlayerMeta pData = PlayerMeta.getPlayer((UUID)player);
        String pronouns = pData.get("pronouns");
        if (pronouns == null || pronouns.isBlank()) {
            return ",";
        }
        return pronouns.toLowerCase();
    }

    static {
        LOGGER = LoggerFactory.getLogger((String)"rcc-pronouns");
    }
}

