/*
 * Decompiled with CFR 0.152.
 */
package io.sc3.plethora.core;

import com.mojang.authlib.GameProfile;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.pocket.IPocketAccess;
import dan200.computercraft.api.pocket.IPocketUpgrade;
import io.sc3.plethora.api.EntityWorldLocation;
import io.sc3.plethora.api.IPlayerOwnable;
import io.sc3.plethora.api.IWorldLocation;
import io.sc3.plethora.api.method.IAttachable;
import io.sc3.plethora.api.method.IContextBuilder;
import io.sc3.plethora.api.method.IContextFactory;
import io.sc3.plethora.api.module.IModuleAccess;
import io.sc3.plethora.api.module.IModuleContainer;
import io.sc3.plethora.api.module.IModuleHandler;
import io.sc3.plethora.api.module.SingletonModuleContainer;
import io.sc3.plethora.api.reference.ConstantReference;
import io.sc3.plethora.api.reference.IReference;
import io.sc3.plethora.core.AttachableWrapperPeripheral;
import io.sc3.plethora.core.Context;
import io.sc3.plethora.core.ContextFactory;
import io.sc3.plethora.core.DefaultCostHandler;
import io.sc3.plethora.core.MethodRegistry;
import io.sc3.plethora.core.RegisteredMethod;
import io.sc3.plethora.core.UnbakedContext;
import io.sc3.plethora.core.executor.TaskRunner;
import io.sc3.plethora.util.PlayerHelpers;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3545;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class PocketUpgradeModule
implements IPocketUpgrade {
    private final IModuleHandler handler;
    private final class_1799 stack;
    private final String adjective;

    public PocketUpgradeModule(@Nonnull class_1799 stack, @Nonnull IModuleHandler handler, @Nonnull String adjective) {
        this.handler = handler;
        this.stack = stack;
        this.adjective = adjective;
    }

    @Nonnull
    public class_2960 getUpgradeID() {
        return this.handler.getModule();
    }

    @Nonnull
    public String getUnlocalisedAdjective() {
        return this.adjective;
    }

    @Nonnull
    public class_1799 getCraftingItem() {
        return this.stack;
    }

    public IPeripheral createPeripheral(final @Nonnull IPocketAccess pocket) {
        class_2960 thisModule = this.handler.getModule();
        String moduleName = thisModule.toString();
        MethodRegistry registry = MethodRegistry.instance;
        final class_1297 entity = pocket.getEntity();
        if (entity == null) {
            return null;
        }
        PocketModuleAccess access = new PocketModuleAccess(pocket, this.handler);
        final IModuleContainer container = access.getContainer();
        ConstantReference<IModuleContainer> containerRef2 = new ConstantReference<IModuleContainer>(){

            @Override
            @Nonnull
            public IModuleContainer get() throws LuaException {
                if (!pocket.getUpgrades().containsKey(PocketUpgradeModule.this.getUpgradeID())) {
                    throw new LuaException("The upgrade is gone");
                }
                return container;
            }

            @Override
            @Nonnull
            public IModuleContainer safeGet() throws LuaException {
                return this.get();
            }
        };
        LastEntityLocation location = new LastEntityLocation(pocket);
        IContextFactory factory = ((ContextFactory)((ContextFactory)((ContextFactory)((ContextFactory)ContextFactory.of(container, containerRef2).withCostHandler(DefaultCostHandler.get(entity))).withModules(container, containerRef2)).addContext("origin", new PocketPlayerOwnable(access))).addContext("origin", location)).addContext("origin", entity, (IReference)new ConstantReference<class_1297>(){

            @Override
            @Nonnull
            public class_1297 get() throws LuaException {
                class_1297 accessEntity = pocket.getEntity();
                if (accessEntity != entity) {
                    throw new LuaException("Entity has changed");
                }
                return accessEntity;
            }

            @Override
            @Nonnull
            public class_1297 safeGet() throws LuaException {
                return this.get();
            }
        });
        this.handler.getAdditionalContext(this.stack, access, (IContextBuilder)((Object)factory));
        class_3545<List<RegisteredMethod<?>>, List<UnbakedContext<?>>> paired = registry.getMethodsPaired((Context<?>)((ContextFactory)factory).getBaked());
        return ((List)paired.method_15442()).isEmpty() ? null : new PocketPeripheral(this, access, paired, ((ContextFactory)factory).getAttachments());
    }

    public void update(@Nonnull IPocketAccess access, IPeripheral peripheral) {
        if (peripheral instanceof PocketPeripheral) {
            PocketPeripheral methodWrapper = (PocketPeripheral)peripheral;
            if (methodWrapper.getEntity() != access.getEntity()) {
                access.invalidatePeripheral();
            }
            methodWrapper.getRunner().update();
        }
    }

    public boolean onRightClick(@Nonnull class_1937 world, @Nonnull IPocketAccess access, IPeripheral peripheral) {
        return false;
    }

    private static final class PocketModuleAccess
    implements IModuleAccess {
        private AttachableWrapperPeripheral wrapper;
        private final IPocketAccess access;
        private final class_1297 entity;
        private final IWorldLocation location;
        private final IModuleContainer container;

        private PocketModuleAccess(IPocketAccess access, IModuleHandler handler) {
            this.entity = access.getEntity();
            this.location = new EntityWorldLocation(this.entity);
            this.access = access;
            this.container = new SingletonModuleContainer(handler.getModule());
        }

        @Nonnull
        public class_1297 getOwner() {
            return this.entity;
        }

        @Override
        @Nonnull
        public IWorldLocation getLocation() {
            return this.location;
        }

        @Override
        @Nonnull
        public IModuleContainer getContainer() {
            return this.container;
        }

        @Override
        @Nonnull
        public class_2487 getData() {
            return this.access.getUpgradeNBTData();
        }

        @Override
        @Nonnull
        public MinecraftServer getServer() {
            return Objects.requireNonNull(this.location.getWorld().method_8503());
        }

        @Override
        public void markDataDirty() {
            this.access.updateUpgradeNBTData();
        }

        @Override
        public void queueEvent(@Nonnull String event, Object ... args) {
            if (this.wrapper != null) {
                this.wrapper.queueEvent(event, args);
            }
        }
    }

    private static class LastEntityLocation
    implements IWorldLocation {
        private final IPocketAccess pocket;
        private class_1297 lastEntity;

        LastEntityLocation(IPocketAccess pocket) {
            this.pocket = pocket;
            this.lastEntity = pocket.getEntity();
        }

        @Override
        @Nonnull
        public class_1937 getWorld() {
            return this.lastEntity.method_5770();
        }

        @Override
        @Nonnull
        public class_2338 getPos() {
            return this.lastEntity.method_24515();
        }

        @Override
        @Nonnull
        public class_243 getLoc() {
            return this.lastEntity.method_19538();
        }

        @Override
        @Nonnull
        public class_238 getBounds() {
            return this.lastEntity.method_5829();
        }

        @Override
        @Nonnull
        public IWorldLocation get() throws LuaException {
            class_1297 entity = this.pocket.getEntity();
            if (entity == null) {
                throw new LuaException("Entity is not there");
            }
            this.lastEntity = entity;
            return this;
        }

        @Override
        @Nonnull
        public IWorldLocation safeGet() {
            return this;
        }

        @Override
        public boolean isConstant() {
            return true;
        }

        public String toString() {
            return new ToStringBuilder((Object)this).append("pocket", (Object)this.pocket).append("lastEntity", (Object)this.lastEntity).append("world", (Object)this.getWorld()).append("loc", (Object)this.getLoc()).toString();
        }
    }

    public static class PocketPlayerOwnable
    implements ConstantReference<PocketPlayerOwnable>,
    IPlayerOwnable {
        private final PocketModuleAccess access;

        public PocketPlayerOwnable(PocketModuleAccess access) {
            this.access = access;
        }

        @Override
        @Nullable
        public GameProfile getOwningProfile() {
            return PlayerHelpers.getProfile(this.access.getOwner());
        }

        @Override
        @Nonnull
        public PocketPlayerOwnable get() {
            return this;
        }

        @Override
        @Nonnull
        public PocketPlayerOwnable safeGet() {
            return this;
        }
    }

    private static final class PocketPeripheral
    extends AttachableWrapperPeripheral {
        private final class_1297 entity;

        public PocketPeripheral(PocketUpgradeModule owner, PocketModuleAccess access, class_3545<List<RegisteredMethod<?>>, List<UnbakedContext<?>>> methods, List<IAttachable> attachments) {
            super(owner.getUpgradeID().toString(), (Object)owner, methods, new TaskRunner(), attachments);
            this.entity = access.entity;
            access.wrapper = this;
        }

        public class_1297 getEntity() {
            return this.entity;
        }

        @Override
        public boolean equals(IPeripheral other) {
            return super.equals(other) && other instanceof PocketPeripheral && this.entity == ((PocketPeripheral)other).entity;
        }
    }
}

