/*
 * Decompiled with CFR 0.152.
 */
package io.sc3.plethora.core;

import dan200.computercraft.api.client.TransformedModel;
import dan200.computercraft.api.peripheral.IPeripheral;
import io.sc3.plethora.api.EntityWorldLocation;
import io.sc3.plethora.api.IWorldLocation;
import io.sc3.plethora.api.method.CostHelpers;
import io.sc3.plethora.api.method.IContextBuilder;
import io.sc3.plethora.api.method.IContextFactory;
import io.sc3.plethora.api.method.ICostHandler;
import io.sc3.plethora.api.module.IModuleAccess;
import io.sc3.plethora.api.module.IModuleContainer;
import io.sc3.plethora.api.module.IModuleHandler;
import io.sc3.plethora.api.module.SingletonModuleContainer;
import io.sc3.plethora.api.reference.ConstantReference;
import io.sc3.plethora.api.reference.IReference;
import io.sc3.plethora.api.reference.Reference;
import io.sc3.plethora.api.vehicle.IVehicleAccess;
import io.sc3.plethora.api.vehicle.IVehicleUpgradeHandler;
import io.sc3.plethora.core.AttachableWrapperPeripheral;
import io.sc3.plethora.core.Context;
import io.sc3.plethora.core.ContextFactory;
import io.sc3.plethora.core.MethodRegistry;
import io.sc3.plethora.core.MethodWrapperPeripheral;
import io.sc3.plethora.core.RegisteredMethod;
import io.sc3.plethora.core.UnbakedContext;
import io.sc3.plethora.core.executor.TaskRunner;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3545;
import net.minecraft.server.MinecraftServer;

public class VehicleUpgradeModule
implements IVehicleUpgradeHandler {
    private final IModuleHandler handler;

    public VehicleUpgradeModule(IModuleHandler handler) {
        this.handler = handler;
    }

    @Override
    @Nonnull
    public TransformedModel getModel(@Nonnull IVehicleAccess access) {
        return this.handler.getModel();
    }

    @Override
    public void update(@Nonnull IVehicleAccess vehicle, @Nonnull IPeripheral peripheral) {
        if (peripheral instanceof MethodWrapperPeripheral) {
            // empty if block
        }
    }

    @Override
    @Nullable
    public IPeripheral create(@Nonnull IVehicleAccess vehicle) {
        AttachableWrapperPeripheral peripheral;
        class_2960 thisModule = this.handler.getModule();
        String moduleName = thisModule.toString();
        MethodRegistry registry = MethodRegistry.instance;
        class_1297 entity = vehicle.getVehicle();
        ICostHandler cost = CostHelpers.getCostHandler(entity, null);
        VehicleModuleAccess access = new VehicleModuleAccess(vehicle, this.handler);
        final IModuleContainer container = access.getContainer();
        ConstantReference<IModuleContainer> containerRef2 = new ConstantReference<IModuleContainer>(){

            @Override
            @Nonnull
            public IModuleContainer get() {
                return container;
            }

            @Override
            @Nonnull
            public IModuleContainer safeGet() {
                return this.get();
            }
        };
        IContextFactory factory = ((ContextFactory)((ContextFactory)((ContextFactory)((ContextFactory)ContextFactory.of(container, containerRef2).withCostHandler(cost)).withModules(container, containerRef2)).addContext("origin", new EntityWorldLocation(entity))).addContext("origin", vehicle, (IReference)Reference.id(vehicle))).addContext("origin", vehicle.getVehicle(), (IReference)Reference.entity(vehicle.getVehicle()));
        this.handler.getAdditionalContext(class_1799.field_8037, access, (IContextBuilder)((Object)factory));
        class_3545<List<RegisteredMethod<?>>, List<UnbakedContext<?>>> paired = registry.getMethodsPaired((Context<?>)((ContextFactory)factory).getBaked());
        if (((List)paired.method_15442()).isEmpty()) {
            return null;
        }
        access.wrapper = peripheral = new AttachableWrapperPeripheral(moduleName, (Object)this, paired, new TaskRunner(), ((ContextFactory)factory).getAttachments());
        return peripheral;
    }

    private static final class VehicleModuleAccess
    implements IModuleAccess {
        private AttachableWrapperPeripheral wrapper;
        private final IVehicleAccess access;
        private final IWorldLocation location;
        private final IModuleContainer container;

        private VehicleModuleAccess(IVehicleAccess access, IModuleHandler handler) {
            this.access = access;
            this.location = new EntityWorldLocation(access.getVehicle());
            this.container = new SingletonModuleContainer(handler.getModule());
        }

        @Override
        @Nonnull
        public Object getOwner() {
            return this.access;
        }

        @Override
        @Nonnull
        public IWorldLocation getLocation() {
            return this.location;
        }

        @Override
        @Nonnull
        public IModuleContainer getContainer() {
            return this.container;
        }

        @Override
        @Nonnull
        public class_2487 getData() {
            return this.access.getData();
        }

        @Override
        @Nonnull
        public MinecraftServer getServer() {
            return Objects.requireNonNull(this.location.getWorld().method_8503());
        }

        @Override
        public void markDataDirty() {
            this.access.markDataDirty();
        }

        @Override
        public void queueEvent(@Nonnull String event, Object ... args) {
            if (this.wrapper != null) {
                this.wrapper.queueEvent(event, args);
            }
        }
    }
}

