/*
 * Decompiled with CFR 0.152.
 */
package io.sc3.plethora.gameplay.redstone;

import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.impl.BundledRedstone;
import io.sc3.plethora.Plethora;
import io.sc3.plethora.gameplay.BaseBlockEntity;
import io.sc3.plethora.gameplay.redstone.RedstoneIntegratorPeripheral;
import io.sc3.plethora.gameplay.redstone.RedstoneIntegratorTicker;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2457;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0015\n\u0002\b\u0006\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 42\u00020\u0001:\u00014B#\u0012\n\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\r\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\r\u0010\r\u001a\u00020\n\u00a2\u0006\u0004\b\r\u0010\fJ\u0017\u0010\u0011\u001a\u00020\u00102\b\b\u0001\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0015\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0004\b\u0013\u0010\u0012J\u000f\u0010\u0014\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\u0014\u0010\fJ\r\u0010\u0015\u001a\u00020\n\u00a2\u0006\u0004\b\u0015\u0010\fJ\r\u0010\u0016\u001a\u00020\n\u00a2\u0006\u0004\b\u0016\u0010\fR\u0017\u0010\u0018\u001a\u00020\u00178\u0006\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u001a\u0010\u001bR\u0017\u0010\u001c\u001a\u00020\u00178\u0006\u00a2\u0006\f\n\u0004\b\u001c\u0010\u0019\u001a\u0004\b\u001d\u0010\u001bR\u001d\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e8\u0006\u00a2\u0006\f\n\u0004\b \u0010!\u001a\u0004\b\"\u0010#R\u0016\u0010%\u001a\u00020$8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b%\u0010&R\u0017\u0010(\u001a\u00020'8\u0006\u00a2\u0006\f\n\u0004\b(\u0010)\u001a\u0004\b*\u0010+R\u0016\u0010,\u001a\u00020$8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b,\u0010&R\u0017\u0010-\u001a\u00020'8\u0006\u00a2\u0006\f\n\u0004\b-\u0010)\u001a\u0004\b.\u0010+R\u0017\u00100\u001a\u00020/8\u0006\u00a2\u0006\f\n\u0004\b0\u00101\u001a\u0004\b2\u00103\u00a8\u00065"}, d2={"Lio/sc3/plethora/gameplay/redstone/RedstoneIntegratorBlockEntity;", "Lio/sc3/plethora/gameplay/BaseBlockEntity;", "Lnet/minecraft/class_2591;", "type", "Lnet/minecraft/class_2338;", "pos", "Lnet/minecraft/class_2680;", "state", "<init>", "(Lnet/minecraft/class_2591;Lnet/minecraft/class_2338;Lnet/minecraft/class_2680;)V", "", "enqueueInputTick", "()V", "enqueueOutputTick", "Lnet/minecraft/class_2350;", "side", "", "getBundledRedstoneOutput", "(Lnet/minecraft/class_2350;)I", "getRedstoneOutput", "onChunkLoaded", "updateInput", "updateOnce", "", "bundledInputs", "[I", "getBundledInputs", "()[I", "bundledOutputs", "getBundledOutputs", "", "Ldan200/computercraft/api/peripheral/IComputerAccess;", "computers", "Ljava/util/Set;", "getComputers", "()Ljava/util/Set;", "", "inputDirty", "Z", "", "inputs", "[B", "getInputs", "()[B", "outputDirty", "outputs", "getOutputs", "Lio/sc3/plethora/gameplay/redstone/RedstoneIntegratorPeripheral;", "peripheral", "Lio/sc3/plethora/gameplay/redstone/RedstoneIntegratorPeripheral;", "getPeripheral", "()Lio/sc3/plethora/gameplay/redstone/RedstoneIntegratorPeripheral;", "Companion", "Plethora-Fabric"})
@SourceDebugExtension(value={"SMAP\nRedstoneIntegratorBlockEntity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RedstoneIntegratorBlockEntity.kt\nio/sc3/plethora/gameplay/redstone/RedstoneIntegratorBlockEntity\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,154:1\n1855#2,2:155\n*S KotlinDebug\n*F\n+ 1 RedstoneIntegratorBlockEntity.kt\nio/sc3/plethora/gameplay/redstone/RedstoneIntegratorBlockEntity\n*L\n40#1:155,2\n*E\n"})
public final class RedstoneIntegratorBlockEntity
extends BaseBlockEntity {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final byte[] inputs;
    @NotNull
    private final byte[] outputs;
    @NotNull
    private final int[] bundledInputs;
    @NotNull
    private final int[] bundledOutputs;
    private boolean outputDirty;
    private boolean inputDirty;
    @NotNull
    private final Set<IComputerAccess> computers;
    @NotNull
    private final RedstoneIntegratorPeripheral peripheral;

    public RedstoneIntegratorBlockEntity(@NotNull class_2591<?> type, @NotNull class_2338 pos, @NotNull class_2680 state) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        super(type, pos, state);
        this.inputs = new byte[6];
        this.outputs = new byte[6];
        this.bundledInputs = new int[6];
        this.bundledOutputs = new int[6];
        Set set = Collections.newSetFromMap(new ConcurrentHashMap());
        Intrinsics.checkNotNullExpressionValue(set, (String)"newSetFromMap(...)");
        this.computers = set;
        this.peripheral = new RedstoneIntegratorPeripheral(this);
    }

    @NotNull
    public final byte[] getInputs() {
        return this.inputs;
    }

    @NotNull
    public final byte[] getOutputs() {
        return this.outputs;
    }

    @NotNull
    public final int[] getBundledInputs() {
        return this.bundledInputs;
    }

    @NotNull
    public final int[] getBundledOutputs() {
        return this.bundledOutputs;
    }

    @NotNull
    public final Set<IComputerAccess> getComputers() {
        return this.computers;
    }

    @NotNull
    public final RedstoneIntegratorPeripheral getPeripheral() {
        return this.peripheral;
    }

    public final void updateInput() {
        class_1937 class_19372 = this.field_11863;
        if (class_19372 == null) {
            return;
        }
        class_1937 world = class_19372;
        if (world.field_9236 || this.method_11015() || !world.method_22340(this.field_11867)) {
            return;
        }
        boolean changed = false;
        Iterable $this$forEach$iv = (Iterable)EntriesMappings.entries$0;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            short newBundled;
            class_2350 dir = (class_2350)element$iv;
            boolean bl = false;
            class_2338 offset = this.field_11867.method_10093(dir);
            class_2350 offsetSide = dir.method_10153();
            int dirIdx = dir.ordinal();
            Intrinsics.checkNotNull((Object)offset);
            Intrinsics.checkNotNull((Object)offsetSide);
            byte newInput = (byte)RedstoneIntegratorBlockEntity.Companion.getRedstoneInput(world, offset, offsetSide);
            if (newInput != this.inputs[dirIdx]) {
                this.inputs[dirIdx] = newInput;
                changed = true;
            }
            if (this.bundledInputs[dirIdx] == (newBundled = (short)BundledRedstone.getOutput((class_1937)world, (class_2338)offset, (class_2350)offsetSide))) continue;
            this.bundledInputs[dirIdx] = newBundled;
            changed = true;
        }
        if (changed) {
            this.enqueueInputTick();
        }
    }

    public final void updateOnce() {
        class_1937 class_19372 = this.field_11863;
        if (class_19372 == null) {
            return;
        }
        class_1937 world = class_19372;
        if (world.field_9236 || this.method_11015() || !world.method_22340(this.field_11867)) {
            return;
        }
        if (this.outputDirty) {
            for (class_2350 dir : EntriesMappings.entries$0) {
                class_2338 class_23382 = this.field_11867;
                Intrinsics.checkNotNullExpressionValue((Object)class_23382, (String)"pos");
                RedstoneIntegratorBlockEntity.Companion.propagateRedstoneOutput(world, class_23382, dir);
            }
            this.outputDirty = false;
        }
        if (this.inputDirty) {
            Iterator<IComputerAccess> computers = this.computers.iterator();
            while (computers.hasNext()) {
                IComputerAccess computer = computers.next();
                try {
                    Object[] objectArray = new Object[]{computer.getAttachmentName()};
                    computer.queueEvent("redstone", objectArray);
                }
                catch (RuntimeException e) {
                    Plethora.log.error("Could not queue redstone event", (Throwable)e);
                    computers.remove();
                }
            }
            this.inputDirty = false;
        }
    }

    public final void enqueueInputTick() {
        if (!this.inputDirty) {
            this.inputDirty = true;
            RedstoneIntegratorTicker.INSTANCE.enqueueTick(this);
        }
    }

    public final void enqueueOutputTick() {
        if (!this.outputDirty) {
            this.outputDirty = true;
            RedstoneIntegratorTicker.INSTANCE.enqueueTick(this);
        }
    }

    @Override
    public void onChunkLoaded() {
        super.onChunkLoaded();
        this.enqueueOutputTick();
    }

    public final int getRedstoneOutput(@NotNull class_2350 side) {
        Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        return this.outputs[side.ordinal()];
    }

    public final int getBundledRedstoneOutput(@Nonnull @NotNull class_2350 side) {
        Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        return this.bundledOutputs[side.ordinal()];
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J'\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\u000b\u0010\fJ'\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lio/sc3/plethora/gameplay/redstone/RedstoneIntegratorBlockEntity$Companion;", "", "<init>", "()V", "Lnet/minecraft/class_1937;", "world", "Lnet/minecraft/class_2338;", "pos", "Lnet/minecraft/class_2350;", "side", "", "getRedstoneInput", "(Lnet/minecraft/class_1937;Lnet/minecraft/class_2338;Lnet/minecraft/class_2350;)I", "", "propagateRedstoneOutput", "(Lnet/minecraft/class_1937;Lnet/minecraft/class_2338;Lnet/minecraft/class_2350;)V", "Plethora-Fabric"})
    public static final class Companion {
        private Companion() {
        }

        private final int getRedstoneInput(class_1937 world, class_2338 pos, class_2350 side) {
            int n;
            int power = world.method_49808(pos, side);
            if (power >= 15) {
                return power;
            }
            class_2680 neighbour = world.method_8320(pos);
            if (neighbour.method_26204() == class_2246.field_10091) {
                Comparable comparable = neighbour.method_11654((class_2769)class_2457.field_11432);
                Intrinsics.checkNotNullExpressionValue((Object)comparable, (String)"get(...)");
                int n2 = ((Number)((Object)comparable)).intValue();
                n = Math.max(power, n2);
            } else {
                n = power;
            }
            return n;
        }

        private final void propagateRedstoneOutput(class_1937 world, class_2338 pos, class_2350 side) {
            class_2680 block = world.method_8320(pos);
            class_2338 neighbourPos = pos.method_10093(side);
            world.method_8492(neighbourPos, block.method_26204(), pos);
            world.method_8508(neighbourPos, block.method_26204(), side.method_10153());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class EntriesMappings {
        public static final /* synthetic */ EnumEntries<class_2350> entries$0;

        static {
            entries$0 = EnumEntriesKt.enumEntries((Enum[])((Enum[])class_2350.values()));
        }
    }
}

