/*
 * Decompiled with CFR 0.152.
 */
package fr.juke.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import fr.juke.FabricTab;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import net.fabricmc.loader.api.FabricLoader;

public class Config {
    public static Config INSTANCE = new Config();
    public int configVersion;
    public String header;
    public String footer;
    public String motd;
    public int refreshTickInterval;
    public boolean enabled;

    public void setDefaults() throws IOException {
        if (this.configVersion < 1) {
            this.configVersion = 1;
            this.header = "\u00a77\u00a7l\u00a7oCOOL#N      SERVER       #N#N\u00a76very cool\u00a7f#N";
            this.footer = "#N\u00a7b#TPS tps - #MSPT mspt - #PLAYERCOUNT players - #UPTIME uptime#N";
            this.motd = "\u00a77\u00a7oWelcome to the server.\u00a7f";
            this.save();
            FabricTab.LOGGER.info("Migrated configuration file to v1");
        }
        if (this.configVersion < 2) {
            this.configVersion = 2;
            this.enabled = true;
            this.refreshTickInterval = 20;
            this.save();
            FabricTab.LOGGER.info("Migrated configuration file to v2");
        }
    }

    public void save() throws IOException {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        File config = new File(FabricLoader.getInstance().getConfigDirectory(), "fabric-tab.json");
        try (FileWriter file = new FileWriter(config);){
            file.write(gson.toJson((Object)this));
        }
    }

    public void load() throws IOException {
        File config1 = new File(FabricLoader.getInstance().getConfigDirectory(), "fabric-tab.json");
        if (!config1.exists()) {
            this.save();
        }
        if (config1.isDirectory() && config1.delete()) {
            this.save();
        }
        try (FileReader reader = new FileReader(config1);){
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            Config readConfig = (Config)gson.fromJson((Reader)reader, Config.class);
            this.configVersion = readConfig.configVersion;
            this.header = readConfig.header;
            this.footer = readConfig.footer;
            this.motd = readConfig.motd;
            this.refreshTickInterval = readConfig.refreshTickInterval;
            this.enabled = readConfig.enabled;
            this.setDefaults();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }
}

