/*
 * Decompiled with CFR 0.152.
 */
package io.sc3.peripherals.posters;

import io.sc3.peripherals.posters.PosterPrintDataKt;
import io.sc3.peripherals.posters.PosterUpdateS2CPacket;
import java.io.File;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.class_18;
import net.minecraft.class_2487;
import net.minecraft.class_2596;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0005\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0006\n\u0002\u0010\u0015\n\u0002\b\t\u0018\u0000 .2\u00020\u0001:\u0002./B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0007\u001a\u00020\u00062\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004H\u0096\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J%\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u0013\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0019\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\u00192\u0006\u0010\u0018\u001a\u00020\u0017\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0017\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001cH\u0016\u00a2\u0006\u0004\b\u001e\u0010\u001fR\"\u0010!\u001a\u00020 8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b!\u0010\"\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\"\u0010(\u001a\u00020'8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b(\u0010)\u001a\u0004\b*\u0010+\"\u0004\b,\u0010-\u00a8\u00060"}, d2={"Lio/sc3/peripherals/posters/PosterState;", "Lnet/minecraft/class_18;", "<init>", "()V", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "Ljava/io/File;", "file", "", "save", "(Ljava/io/File;)V", "x", "z", "", "color", "setColor", "(IIB)V", "", "id", "Lnet/minecraft/class_2596;", "toPacket", "(Ljava/lang/String;)Lnet/minecraft/class_2596;", "Lnet/minecraft/class_2487;", "nbt", "writeNbt", "(Lnet/minecraft/class_2487;)Lnet/minecraft/class_2487;", "", "colors", "[B", "getColors", "()[B", "setColors", "([B)V", "", "palette", "[I", "getPalette", "()[I", "setPalette", "([I)V", "Companion", "UpdateData", "sc-peripherals"})
public final class PosterState
extends class_18 {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private byte[] colors = new byte[16384];
    @NotNull
    private int[] palette = PosterPrintDataKt.getDefaultPalette();

    @NotNull
    public final byte[] getColors() {
        return this.colors;
    }

    public final void setColors(@NotNull byte[] byArray) {
        Intrinsics.checkNotNullParameter((Object)byArray, (String)"<set-?>");
        this.colors = byArray;
    }

    @NotNull
    public final int[] getPalette() {
        return this.palette;
    }

    public final void setPalette(@NotNull int[] nArray) {
        Intrinsics.checkNotNullParameter((Object)nArray, (String)"<set-?>");
        this.palette = nArray;
    }

    public void method_17919(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        file.getParentFile().mkdirs();
        super.method_17919(file);
    }

    public final void setColor(int x, int z, byte color) {
        this.colors[x + z * 128] = color;
        this.method_78(true);
    }

    @NotNull
    public class_2487 method_75(@NotNull class_2487 nbt) {
        class_2487 class_24872;
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        class_2487 $this$writeNbt_u24lambda_u240 = class_24872 = nbt;
        boolean bl = false;
        $this$writeNbt_u24lambda_u240.method_10570("colors", this.colors);
        $this$writeNbt_u24lambda_u240.method_10539("palette", this.palette);
        return class_24872;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(((Object)((Object)this)).getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type io.sc3.peripherals.posters.PosterState");
        PosterState cfr_ignored_0 = (PosterState)((Object)other);
        if (!Arrays.equals(this.colors, ((PosterState)((Object)other)).colors)) {
            return false;
        }
        return Arrays.equals(this.palette, ((PosterState)((Object)other)).palette);
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.colors);
        result = 31 * result + Arrays.hashCode(this.palette);
        return result;
    }

    @NotNull
    public final class_2596<?> toPacket(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return new PosterUpdateS2CPacket(id, new UpdateData(0, 0, 128, 128, this.colors, this.palette)).toS2CPacket();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lio/sc3/peripherals/posters/PosterState$Companion;", "", "<init>", "()V", "Lnet/minecraft/class_2487;", "nbt", "Lio/sc3/peripherals/posters/PosterState;", "fromNbt", "(Lnet/minecraft/class_2487;)Lio/sc3/peripherals/posters/PosterState;", "sc-peripherals"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final PosterState fromNbt(@NotNull class_2487 nbt) {
            int[] paletteArray;
            Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
            PosterState posterState = new PosterState();
            byte[] colorArray = nbt.method_10547("colors");
            if (colorArray.length == 16384) {
                Intrinsics.checkNotNull((Object)colorArray);
                posterState.setColors(colorArray);
            }
            if ((paletteArray = nbt.method_10561("palette")).length <= 64) {
                Intrinsics.checkNotNull((Object)paletteArray);
                posterState.setPalette(paletteArray);
            }
            return posterState;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0010\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0002\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0015\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0015\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u0012\u0010\u0011R\u0017\u0010\b\u001a\u00020\u00078\u0006\u00a2\u0006\f\n\u0004\b\b\u0010\u0013\u001a\u0004\b\u0014\u0010\u0015R\u0017\u0010\u0006\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0016\u001a\u0004\b\u0017\u0010\u0018R\u0017\u0010\n\u001a\u00020\t8\u0006\u00a2\u0006\f\n\u0004\b\n\u0010\u0019\u001a\u0004\b\u001a\u0010\u001bR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0016\u001a\u0004\b\u001c\u0010\u0018R\u0017\u0010\u0004\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0016\u001a\u0004\b\u001d\u0010\u0018R\u0017\u0010\u0005\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0016\u001a\u0004\b\u001e\u0010\u0018\u00a8\u0006\u001f"}, d2={"Lio/sc3/peripherals/posters/PosterState$UpdateData;", "", "", "startX", "startZ", "width", "height", "", "colors", "", "palette", "<init>", "(IIII[B[I)V", "Lio/sc3/peripherals/posters/PosterState;", "posterState", "", "setColorsTo", "(Lio/sc3/peripherals/posters/PosterState;)V", "setPaletteTo", "[B", "getColors", "()[B", "I", "getHeight", "()I", "[I", "getPalette", "()[I", "getStartX", "getStartZ", "getWidth", "sc-peripherals"})
    public static final class UpdateData {
        private final int startX;
        private final int startZ;
        private final int width;
        private final int height;
        @NotNull
        private final byte[] colors;
        @NotNull
        private final int[] palette;

        public UpdateData(int startX, int startZ, int width, int height, @NotNull byte[] colors, @NotNull int[] palette) {
            Intrinsics.checkNotNullParameter((Object)colors, (String)"colors");
            Intrinsics.checkNotNullParameter((Object)palette, (String)"palette");
            this.startX = startX;
            this.startZ = startZ;
            this.width = width;
            this.height = height;
            this.colors = colors;
            this.palette = palette;
        }

        public final int getStartX() {
            return this.startX;
        }

        public final int getStartZ() {
            return this.startZ;
        }

        public final int getWidth() {
            return this.width;
        }

        public final int getHeight() {
            return this.height;
        }

        @NotNull
        public final byte[] getColors() {
            return this.colors;
        }

        @NotNull
        public final int[] getPalette() {
            return this.palette;
        }

        public final void setColorsTo(@NotNull PosterState posterState) {
            Intrinsics.checkNotNullParameter((Object)((Object)posterState), (String)"posterState");
            int n = this.width;
            for (int i2 = 0; i2 < n; ++i2) {
                int n2 = this.height;
                for (int j = 0; j < n2; ++j) {
                    posterState.setColor(this.startX + i2, this.startZ + j, this.colors[i2 + j * this.width]);
                }
            }
        }

        public final void setPaletteTo(@NotNull PosterState posterState) {
            Intrinsics.checkNotNullParameter((Object)((Object)posterState), (String)"posterState");
            posterState.setPalette(this.palette);
            posterState.method_78(true);
        }
    }
}

