/*
 * Decompiled with CFR 0.152.
 */
package cc.reconnected.essentials.commands.misc;

import cc.reconnected.essentials.RccEssentials;
import cc.reconnected.essentials.core.MailManager;
import cc.reconnected.essentials.data.ServerState;
import cc.reconnected.essentials.struct.PlayerMail;
import cc.reconnected.essentials.util.Components;
import cc.reconnected.library.text.Placeholder;
import cc.reconnected.library.text.parser.MarkdownParser;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import eu.pb4.placeholders.api.PlaceholderContext;
import eu.pb4.placeholders.api.node.TextNode;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Map;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import net.minecraft.class_5250;
import net.minecraft.server.MinecraftServer;

public class MailCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        LiteralArgumentBuilder rootCommand = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"mail").requires(Permissions.require((String)"rcc.command.mail", (boolean)true))).executes(MailCommand::listMails)).then(class_2170.method_9247((String)"send").then(class_2170.method_9244((String)"recipient", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> {
            class_3324 playerManager = ((class_2168)context.getSource()).method_9211().method_3760();
            return class_2172.method_9253((String[])playerManager.method_14580(), (SuggestionsBuilder)builder);
        }).then(class_2170.method_9244((String)"message", (ArgumentType)StringArgumentType.greedyString()).executes(MailCommand::sendMail))))).then(class_2170.method_9247((String)"read").then(class_2170.method_9244((String)"index", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(MailCommand::readMail)))).then(class_2170.method_9247((String)"delete").then(class_2170.method_9244((String)"index", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(MailCommand::deleteMail)));
        dispatcher.register(rootCommand);
    }

    private static int listMails(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        PlaceholderContext playerContext = PlaceholderContext.of((class_3222)player);
        List<PlayerMail> mails = MailManager.getMailList(player.method_5667());
        ServerState serverState = RccEssentials.state.getServerState();
        class_5250 output = class_2561.method_43473().method_10852(Placeholder.parse((String)RccEssentials.CONFIG.textFormats.commands.mail.mailListHeader, (PlaceholderContext)playerContext)).method_10852(class_2561.method_30163((String)"\n"));
        for (int i = 0; i < mails.size(); ++i) {
            if (i > 0) {
                output = output.method_10852(class_2561.method_30163((String)"\n"));
            }
            PlayerMail mail = mails.get(i);
            int index = i + 1;
            class_2561 readButton = Components.button(RccEssentials.CONFIG.textFormats.commands.mail.readButton, RccEssentials.CONFIG.textFormats.commands.mail.hoverRead, "/mail read " + index);
            String senderName = serverState.usernameCache.getOrDefault(mail.sender, mail.sender.toString());
            SimpleDateFormat dateFormatter = new SimpleDateFormat(RccEssentials.CONFIG.textFormats.dateTimeFormat);
            Map<String, class_2561> placeholders = Map.of("index", class_2561.method_30163((String)String.valueOf(index)), "sender", class_2561.method_30163((String)senderName), "date", class_2561.method_30163((String)dateFormatter.format(mail.date)), "readButton", readButton);
            output = output.method_10852(Placeholder.parse((String)RccEssentials.CONFIG.textFormats.commands.mail.mailListEntry, (PlaceholderContext)playerContext, placeholders));
        }
        class_5250 finalOutput = output;
        ((class_2168)context.getSource()).method_9226(() -> finalOutput, false);
        return 1;
    }

    private static int readMail(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        PlaceholderContext playerContext = PlaceholderContext.of((class_3222)player);
        List<PlayerMail> mails = MailManager.getMailList(player.method_5667());
        ServerState serverState = RccEssentials.state.getServerState();
        int index = IntegerArgumentType.getInteger(context, (String)"index") - 1;
        if (index < 0 || index >= mails.size()) {
            ((class_2168)context.getSource()).method_9226(() -> Placeholder.parse((String)RccEssentials.CONFIG.textFormats.commands.mail.notFound), false);
            return 1;
        }
        PlayerMail mail = mails.get(index);
        String username = serverState.usernameCache.getOrDefault(mail.sender, mail.sender.toString());
        class_2561 replyButton = Components.buttonSuggest(RccEssentials.CONFIG.textFormats.commands.mail.replyButton, RccEssentials.CONFIG.textFormats.commands.mail.hoverReply, "/mail send " + username + " ");
        class_2561 deleteButton = Components.button(RccEssentials.CONFIG.textFormats.commands.mail.deleteButton, RccEssentials.CONFIG.textFormats.commands.mail.hoverDelete, "/mail delete " + index + "1");
        String senderName = serverState.usernameCache.getOrDefault(mail.sender, mail.sender.toString());
        SimpleDateFormat dateFormatter = new SimpleDateFormat(RccEssentials.CONFIG.textFormats.dateTimeFormat);
        TextNode message = MarkdownParser.defaultParser.parseNode(mail.message);
        Map<String, class_2561> placeholders = Map.of("sender", class_2561.method_30163((String)senderName), "date", class_2561.method_30163((String)dateFormatter.format(mail.date)), "message", message.toText(), "replyButton", replyButton, "deleteButton", deleteButton);
        ((class_2168)context.getSource()).method_9226(() -> Placeholder.parse((String)RccEssentials.CONFIG.textFormats.commands.mail.mailDetails, (PlaceholderContext)playerContext, (Map)placeholders), false);
        return 1;
    }

    private static int deleteMail(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        PlaceholderContext playerContext = PlaceholderContext.of((class_3222)player);
        int index = IntegerArgumentType.getInteger(context, (String)"index") - 1;
        if (MailManager.deleteMail(player.method_5667(), index)) {
            ((class_2168)context.getSource()).method_9226(() -> Placeholder.parse((String)RccEssentials.CONFIG.textFormats.commands.mail.mailDeleted, (PlaceholderContext)playerContext), false);
        } else {
            ((class_2168)context.getSource()).method_9226(() -> Placeholder.parse((String)RccEssentials.CONFIG.textFormats.commands.mail.notFound), false);
        }
        return 1;
    }

    private static int sendMail(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 sender = ((class_2168)context.getSource()).method_9207();
        String username = StringArgumentType.getString(context, (String)"recipient");
        ((class_2168)context.getSource()).method_9211().method_3793().method_37156(username, gameProfile -> {
            if (gameProfile.isEmpty()) {
                PlaceholderContext playerContext = PlaceholderContext.of((class_3222)sender);
                Map<String, class_2561> placeholders = Map.of("recipient", class_2561.method_30163((String)username));
                ((class_2168)context.getSource()).method_9226(() -> Placeholder.parse((String)RccEssentials.CONFIG.textFormats.commands.mail.playerNotFound, (PlaceholderContext)playerContext, (Map)placeholders), false);
                return;
            }
            String message = StringArgumentType.getString((CommandContext)context, (String)"message");
            GameProfile recipient = (GameProfile)gameProfile.get();
            MinecraftServer server = ((class_2168)context.getSource()).method_9211();
            PlayerMail mail = new PlayerMail(message, sender.method_5667());
            MailManager.sendMail(recipient.getId(), mail);
            PlaceholderContext senderContext = PlaceholderContext.of((class_3222)sender);
            ((class_2168)context.getSource()).method_9226(() -> Placeholder.parse((String)RccEssentials.CONFIG.textFormats.commands.mail.mailSent, (PlaceholderContext)senderContext), false);
            class_3222 recPlayer = server.method_3760().method_14602(recipient.getId());
            if (recPlayer == null) {
                return;
            }
            PlaceholderContext recContext = PlaceholderContext.of((class_3222)recPlayer);
            recPlayer.method_43496(Placeholder.parse((String)RccEssentials.CONFIG.textFormats.commands.mail.mailReceived, (PlaceholderContext)recContext));
        });
        return 1;
    }
}

