/*
 * Decompiled with CFR 0.152.
 */
package cc.reconnected.essentials.commands.misc;

import cc.reconnected.essentials.RccEssentials;
import cc.reconnected.essentials.data.PlayerState;
import cc.reconnected.essentials.struct.ServerPosition;
import cc.reconnected.library.text.Placeholder;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import eu.pb4.placeholders.api.PlaceholderContext;
import java.text.SimpleDateFormat;
import java.util.Map;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.minecraft.class_1297;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class SeenCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        LiteralCommandNode rootCommand = dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"seen").requires(Permissions.require((String)"rcc.command.seen", (boolean)true))).then(class_2170.method_9244((String)"player", (ArgumentType)StringArgumentType.word()).executes(context -> {
            String targetName = StringArgumentType.getString((CommandContext)context, (String)"player");
            class_2168 source = (class_2168)context.getSource();
            source.method_9211().method_3793().method_37156(targetName, profile -> {
                if (profile.isEmpty()) {
                    source.method_9226(() -> Placeholder.parse((String)RccEssentials.CONFIG.textFormats.commands.seen.playerNotFound), false);
                    return;
                }
                boolean extended = ((class_2168)context.getSource()).method_43737() ? Permissions.check((class_1297)((class_2168)context.getSource()).method_44023(), (String)"rcc.command.seen.extended", (int)2) : true;
                SimpleDateFormat dateFormatter = new SimpleDateFormat(RccEssentials.CONFIG.textFormats.dateTimeFormat);
                class_3222 player = source.method_9211().method_3760().method_14602(((GameProfile)profile.get()).getId());
                PlayerState playerState = RccEssentials.state.getPlayerState(((GameProfile)profile.get()).getId());
                ServerPosition location = player == null ? playerState.logoffPosition : new ServerPosition(player);
                Map<String, class_2561> map = Map.of("username", class_2561.method_30163((String)((GameProfile)profile.get()).getName()), "uuid", class_2561.method_30163((String)((GameProfile)profile.get()).getId().toString()), "firstSeenDate", class_2561.method_30163((String)dateFormatter.format(playerState.firstJoinedDate)), "lastSeenDate", player != null ? class_2561.method_30163((String)"online") : class_2561.method_30163((String)dateFormatter.format(playerState.lastSeenDate)), "ipAddress", class_2561.method_30163((String)playerState.ipAddress), "location", class_2561.method_30163((String)SeenCommand.getPositionAsString(location)));
                Object outputString = String.join((CharSequence)"\n", RccEssentials.CONFIG.textFormats.commands.seen.base);
                if (extended) {
                    outputString = (String)outputString + "\n";
                    outputString = (String)outputString + String.join((CharSequence)"\n", RccEssentials.CONFIG.textFormats.commands.seen.extended);
                }
                String finalOutput = outputString;
                if (player != null) {
                    source.method_9226(() -> Placeholder.parse((String)finalOutput, (PlaceholderContext)PlaceholderContext.of((class_3222)player), (Map)map), false);
                } else {
                    source.method_9226(() -> Placeholder.parse((String)finalOutput, (PlaceholderContext)PlaceholderContext.of((MinecraftServer)source.method_9211()), (Map)map), false);
                }
            });
            return 1;
        })));
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"playerinfo").redirect((CommandNode)rootCommand));
    }

    public static String getPositionAsString(@Nullable ServerPosition pos) {
        if (pos == null) {
            return "Unknown position";
        }
        return String.format("%.01f %.01f %.01f, %s", pos.x, pos.y, pos.z, pos.world);
    }
}

