/*
 * Decompiled with CFR 0.152.
 */
package cc.reconnected.essentials.core;

import cc.reconnected.essentials.RccEssentials;
import cc.reconnected.essentials.api.events.PlayerActivityEvents;
import cc.reconnected.essentials.api.events.RccEvents;
import cc.reconnected.essentials.data.PlayerState;
import cc.reconnected.library.text.Placeholder;
import eu.pb4.placeholders.api.PlaceholderContext;
import eu.pb4.placeholders.api.PlaceholderResult;
import eu.pb4.placeholders.api.Placeholders;
import eu.pb4.placeholders.api.TextParserUtils;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.player.AttackBlockCallback;
import net.fabricmc.fabric.api.event.player.AttackEntityCallback;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.fabricmc.fabric.api.event.player.UseEntityCallback;
import net.fabricmc.fabric.api.event.player.UseItemCallback;
import net.fabricmc.fabric.api.message.v1.ServerMessageEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class AfkTracker {
    private static final int cycleDelay = 1;
    private static final int absentTimeTrigger = RccEssentials.CONFIG.afk.afkTimeTrigger * 20;
    private final ConcurrentHashMap<UUID, PlayerActivityState> playerActivityStates = new ConcurrentHashMap();
    private static final AfkTracker instance = new AfkTracker();
    public static class_2561 afkTag;

    public static AfkTracker getInstance() {
        return instance;
    }

    public static void register() {
        AfkTracker.loadAfkTag();
        Placeholders.register((class_2960)new class_2960("rcc-essentials", "afk"), (context, argument) -> {
            if (!context.hasPlayer()) {
                return PlaceholderResult.invalid((String)"No player!");
            }
            class_3222 player = context.player();
            if (instance.isPlayerAfk(player.method_5667())) {
                return PlaceholderResult.value((class_2561)afkTag);
            }
            return PlaceholderResult.value((String)"");
        });
        PlayerActivityEvents.AFK.register((player, server) -> {
            RccEssentials.LOGGER.info("{} is AFK. Active time: {} seconds.", (Object)player.method_7334().getName(), (Object)AfkTracker.getInstance().getActiveTime(player));
            PlaceholderContext playerContext = PlaceholderContext.of((class_3222)player);
            RccEssentials.getInstance().broadcast(Placeholder.parse((String)RccEssentials.CONFIG.textFormats.commands.afk.goneAfk, (PlaceholderContext)playerContext));
        });
        PlayerActivityEvents.AFK_RETURN.register((player, server) -> {
            RccEssentials.LOGGER.info("{} is no longer AFK. Active time: {} seconds.", (Object)player.method_7334().getName(), (Object)AfkTracker.getInstance().getActiveTime(player));
            PlaceholderContext playerContext = PlaceholderContext.of((class_3222)player);
            RccEssentials.getInstance().broadcast(Placeholder.parse((String)RccEssentials.CONFIG.textFormats.commands.afk.returnAfk, (PlaceholderContext)playerContext));
        });
        RccEvents.RELOAD.register(inst -> AfkTracker.loadAfkTag());
    }

    private static void loadAfkTag() {
        afkTag = TextParserUtils.formatText((String)RccEssentials.CONFIG.textFormats.commands.afk.tag);
    }

    private AfkTracker() {
        ServerTickEvents.END_SERVER_TICK.register(this::updatePlayers);
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            class_3222 player = handler.method_32311();
            this.playerActivityStates.put(player.method_5667(), new PlayerActivityState(player, server.method_3780()));
        });
        ServerPlayConnectionEvents.DISCONNECT.register((handler, server) -> {
            this.updatePlayerActiveTime(handler.method_32311(), server.method_3780());
            this.playerActivityStates.remove(handler.method_32311().method_5667());
        });
        AttackBlockCallback.EVENT.register((player, world, hand, pos, direction) -> {
            this.resetAfkState((class_3222)player, world.method_8503());
            return class_1269.field_5811;
        });
        AttackEntityCallback.EVENT.register((player, world, hand, entity, hitResult) -> {
            this.resetAfkState((class_3222)player, world.method_8503());
            return class_1269.field_5811;
        });
        UseBlockCallback.EVENT.register((player, world, hand, hitResult) -> {
            this.resetAfkState((class_3222)player, world.method_8503());
            return class_1269.field_5811;
        });
        UseEntityCallback.EVENT.register((player, world, hand, entity, hitResult) -> {
            this.resetAfkState((class_3222)player, world.method_8503());
            return class_1269.field_5811;
        });
        UseItemCallback.EVENT.register((player, world, hand) -> {
            this.resetAfkState((class_3222)player, world.method_8503());
            return class_1271.method_22430((Object)player.method_5998(hand));
        });
        ServerMessageEvents.ALLOW_CHAT_MESSAGE.register((message, sender, params) -> {
            this.resetAfkState(sender, sender.method_5682());
            return true;
        });
        ServerMessageEvents.ALLOW_COMMAND_MESSAGE.register((message, source, params) -> {
            if (!source.method_43737()) {
                return true;
            }
            this.resetAfkState(source.method_44023(), source.method_9211());
            return true;
        });
    }

    private void updatePlayer(class_3222 player, MinecraftServer server) {
        int currentTick = server.method_3780();
        PlayerActivityState playerState = this.playerActivityStates.computeIfAbsent(player.method_5667(), uuid -> new PlayerActivityState(player, currentTick));
        PlayerPosition oldPosition = playerState.position;
        PlayerPosition newPosition = new PlayerPosition(player);
        if (!oldPosition.equals(newPosition)) {
            playerState.position = newPosition;
            this.resetAfkState(player, server);
            return;
        }
        if (playerState.isAfk) {
            return;
        }
        if (playerState.lastUpdate + absentTimeTrigger <= currentTick) {
            this.updatePlayerActiveTime(player, currentTick);
            playerState.isAfk = true;
            ((PlayerActivityEvents.Afk)PlayerActivityEvents.AFK.invoker()).onAfk(player, server);
        }
    }

    private void updatePlayerActiveTime(class_3222 player, int currentTick) {
        PlayerActivityState playerActivityState = this.playerActivityStates.get(player.method_5667());
        if (!playerActivityState.isAfk) {
            PlayerState playerState = RccEssentials.state.getPlayerState(player.method_5667());
            int interval = currentTick - playerActivityState.activeStart;
            playerState.activeTime += interval / 20;
        }
    }

    private void updatePlayers(MinecraftServer server) {
        List players = server.method_3760().method_14571();
        players.forEach(player -> this.updatePlayer((class_3222)player, server));
    }

    private void resetAfkState(class_3222 player, MinecraftServer server) {
        if (!this.playerActivityStates.containsKey(player.method_5667())) {
            return;
        }
        PlayerActivityState playerState = this.playerActivityStates.get(player.method_5667());
        playerState.lastUpdate = server.method_3780();
        if (playerState.isAfk) {
            playerState.isAfk = false;
            playerState.activeStart = server.method_3780();
            ((PlayerActivityEvents.AfkReturn)PlayerActivityEvents.AFK_RETURN.invoker()).onAfkReturn(player, server);
        }
    }

    public boolean isPlayerAfk(UUID playerUuid) {
        if (!this.playerActivityStates.containsKey(playerUuid)) {
            return false;
        }
        return this.playerActivityStates.get((Object)playerUuid).isAfk;
    }

    public void setPlayerAfk(class_3222 player, boolean afk) {
        if (!this.playerActivityStates.containsKey(player.method_5667())) {
            return;
        }
        MinecraftServer server = player.method_37908().method_8503();
        if (afk) {
            this.playerActivityStates.get((Object)player.method_5667()).lastUpdate = -absentTimeTrigger - 20;
        } else {
            this.resetAfkState(player, server);
        }
        this.updatePlayer(player, server);
    }

    public int getActiveTime(class_3222 player) {
        PlayerState playerState = RccEssentials.state.getPlayerState(player.method_5667());
        return playerState.activeTime;
    }

    public static class PlayerActivityState {
        public PlayerPosition position;
        public int lastUpdate;
        public boolean isAfk;
        public int activeStart;

        public PlayerActivityState(class_3222 player, int lastUpdate) {
            this.position = new PlayerPosition(player);
            this.lastUpdate = lastUpdate;
            this.isAfk = false;
            this.activeStart = lastUpdate;
        }
    }

    public static class PlayerPosition {
        public String dimension;
        public double x;
        public double y;
        public double z;
        public float yaw;
        public float pitch;

        public boolean equals(PlayerPosition obj) {
            return this.x == obj.x && this.y == obj.y && this.z == obj.z && this.yaw == obj.yaw && this.pitch == obj.pitch && this.dimension.equals(obj.dimension);
        }

        public PlayerPosition(class_3222 player) {
            this.dimension = player.method_37908().method_27983().method_29177().toString();
            this.x = player.method_23317();
            this.y = player.method_23318();
            this.z = player.method_23321();
            this.yaw = player.method_36454();
            this.pitch = player.method_36455();
        }
    }
}

