/*
 * Decompiled with CFR 0.152.
 */
package cc.reconnected.essentials.core;

import cc.reconnected.essentials.RccEssentials;
import cc.reconnected.essentials.RccEssentialsConfig;
import cc.reconnected.essentials.api.events.RccEvents;
import cc.reconnected.library.RccLibrary;
import cc.reconnected.library.text.Placeholder;
import eu.pb4.placeholders.api.PlaceholderContext;
import java.util.ArrayList;
import java.util.Random;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.luckperms.api.LuckPerms;
import net.luckperms.api.cacheddata.CachedPermissionData;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class AutoAnnouncements {
    private static ScheduledFuture<?> scheduledFuture = null;
    private static int currentLine = 0;
    private static MinecraftServer server;

    public static void register() {
        RccEvents.RELOAD.register(instance -> {
            if (scheduledFuture != null) {
                scheduledFuture.cancel(false);
            }
            AutoAnnouncements.setup();
        });
        ServerLifecycleEvents.SERVER_STARTED.register(mcServer -> {
            server = mcServer;
            AutoAnnouncements.setup();
        });
    }

    public static void announce() {
        ArrayList<RccEssentialsConfig.AutoAnnouncements.Announcement> lines = RccEssentials.CONFIG.autoAnnouncements.announcements;
        if (lines.isEmpty()) {
            return;
        }
        LuckPerms luckperms = RccLibrary.getInstance().luckPerms();
        if (RccEssentials.CONFIG.autoAnnouncements.pickRandomly) {
            currentLine = new Random().nextInt(lines.size());
        }
        RccEssentialsConfig.AutoAnnouncements.Announcement line = lines.get(currentLine %= lines.size());
        ++currentLine;
        server.method_3760().method_14571().forEach(player -> {
            CachedPermissionData permissionData;
            if (line.permission() != null && (permissionData = luckperms.getPlayerAdapter(class_3222.class).getPermissionData(player)).checkPermission(line.permission()).asBoolean() != line.result().booleanValue()) {
                return;
            }
            PlaceholderContext playerContext = PlaceholderContext.of((class_3222)player);
            player.method_43496(Placeholder.parse((String)line.text(), (PlaceholderContext)playerContext));
        });
    }

    private static void setup() {
        currentLine = 0;
        if (RccEssentials.CONFIG.autoAnnouncements.enableAnnouncements) {
            int delay = RccEssentials.CONFIG.autoAnnouncements.delay;
            scheduledFuture = RccEssentials.scheduler.scheduleAtFixedRate(AutoAnnouncements::announce, delay, delay, TimeUnit.SECONDS);
        }
    }
}

