/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.java.lazy.descriptors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.StandardNames;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.MemberDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PropertyDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.SimpleFunctionDescriptor;
import kotlin.reflect.jvm.internal.impl.incremental.components.LookupLocation;
import kotlin.reflect.jvm.internal.impl.incremental.components.NoLookupLocation;
import kotlin.reflect.jvm.internal.impl.load.java.components.DescriptorResolverUtils;
import kotlin.reflect.jvm.internal.impl.load.java.descriptors.UtilKt;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.LazyJavaResolverContext;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.descriptors.ClassDeclaredMemberIndex;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.descriptors.DeclaredMemberIndex;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.descriptors.LazyJavaClassDescriptor;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.descriptors.LazyJavaScope;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.descriptors.LazyJavaStaticClassScope$computeMemberIndex$1;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.descriptors.LazyJavaStaticClassScope$computeNonDeclaredProperties$propertiesFromSupertypes$1;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.descriptors.LazyJavaStaticClassScope$computePropertyNames$1$1;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.descriptors.LazyJavaStaticClassScope$flatMapJavaStaticSupertypesScopes$1;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.descriptors.LazyJavaStaticClassScope$flatMapJavaStaticSupertypesScopes$2;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.descriptors.LazyJavaStaticScope;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaClass;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.resolve.DescriptorFactory;
import kotlin.reflect.jvm.internal.impl.resolve.OverridingUtil;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.DescriptorKindFilter;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.ErrorReporter;
import kotlin.reflect.jvm.internal.impl.utils.DFS;

public final class LazyJavaStaticClassScope
extends LazyJavaStaticScope {
    private final JavaClass jClass;
    private final LazyJavaClassDescriptor ownerDescriptor;

    public LazyJavaStaticClassScope(LazyJavaResolverContext lazyJavaResolverContext, JavaClass javaClass, LazyJavaClassDescriptor lazyJavaClassDescriptor) {
        Intrinsics.checkNotNullParameter(lazyJavaResolverContext, "c");
        Intrinsics.checkNotNullParameter(javaClass, "jClass");
        Intrinsics.checkNotNullParameter(lazyJavaClassDescriptor, "ownerDescriptor");
        super(lazyJavaResolverContext);
        this.jClass = javaClass;
        this.ownerDescriptor = lazyJavaClassDescriptor;
    }

    private final Set getStaticFunctionsFromJavaSuperClasses(Name name, ClassDescriptor classDescriptor) {
        LazyJavaStaticClassScope lazyJavaStaticClassScope = UtilKt.getParentJavaStaticClassScope(classDescriptor);
        if (lazyJavaStaticClassScope == null) {
            return SetsKt.emptySet();
        }
        return CollectionsKt.toSet(lazyJavaStaticClassScope.getContributedFunctions(name, NoLookupLocation.WHEN_GET_SUPER_MEMBERS));
    }

    private final Set flatMapJavaStaticSupertypesScopes(ClassDescriptor classDescriptor, Set set, Function1 function1) {
        DFS.dfs(CollectionsKt.listOf((Object)classDescriptor), LazyJavaStaticClassScope$flatMapJavaStaticSupertypesScopes$1.INSTANCE, new LazyJavaStaticClassScope$flatMapJavaStaticSupertypesScopes$2(classDescriptor, set, function1));
        return set;
    }

    private final PropertyDescriptor getRealOriginal(PropertyDescriptor iterator2) {
        ArrayList<PropertyDescriptor> arrayList;
        if (iterator2.getKind().isReal()) {
            return iterator2;
        }
        iterator2 = iterator2.getOverriddenDescriptors();
        Intrinsics.checkNotNullExpressionValue(iterator2, "this.overriddenDescriptors");
        ArrayList<PropertyDescriptor> arrayList2 = arrayList;
        arrayList = new ArrayList<PropertyDescriptor>(CollectionsKt.collectionSizeOrDefault((Iterable)((Object)iterator2), 10));
        iterator2 = iterator2.iterator();
        while (iterator2.hasNext()) {
            PropertyDescriptor propertyDescriptor = (PropertyDescriptor)iterator2.next();
            Intrinsics.checkNotNullExpressionValue(propertyDescriptor, "it");
            arrayList2.add(this.getRealOriginal(propertyDescriptor));
        }
        return (PropertyDescriptor)CollectionsKt.single(CollectionsKt.distinct(arrayList2));
    }

    @Override
    protected LazyJavaClassDescriptor getOwnerDescriptor() {
        return this.ownerDescriptor;
    }

    @Override
    protected ClassDeclaredMemberIndex computeMemberIndex() {
        return new ClassDeclaredMemberIndex(this.jClass, LazyJavaStaticClassScope$computeMemberIndex$1.INSTANCE);
    }

    @Override
    protected Set computeFunctionNames(DescriptorKindFilter object, Function1 set) {
        LazyJavaStaticClassScope lazyJavaStaticClassScope = this;
        Intrinsics.checkNotNullParameter(object, "kindFilter");
        object = CollectionsKt.toMutableSet(((DeclaredMemberIndex)lazyJavaStaticClassScope.getDeclaredMemberIndex().invoke()).getMethodNames());
        set = UtilKt.getParentJavaStaticClassScope(lazyJavaStaticClassScope.getOwnerDescriptor());
        set = set != null ? ((LazyJavaScope)((Object)set)).getFunctionNames() : null;
        if (set == null) {
            set = SetsKt.emptySet();
        }
        object.addAll(set);
        if (this.jClass.isEnum()) {
            object.addAll(CollectionsKt.listOf(StandardNames.ENUM_VALUE_OF, StandardNames.ENUM_VALUES));
        }
        Object object2 = object;
        object2.addAll(this.getC().getComponents().getSyntheticPartsProvider().getStaticFunctionNames(this.getOwnerDescriptor()));
        return object2;
    }

    @Override
    protected Set computePropertyNames(DescriptorKindFilter object, Function1 function1) {
        Intrinsics.checkNotNullParameter(object, "kindFilter");
        object = CollectionsKt.toMutableSet(((DeclaredMemberIndex)this.getDeclaredMemberIndex().invoke()).getFieldNames());
        LazyJavaStaticClassScope lazyJavaStaticClassScope = this;
        lazyJavaStaticClassScope.flatMapJavaStaticSupertypesScopes(lazyJavaStaticClassScope.getOwnerDescriptor(), (Set)object, LazyJavaStaticClassScope$computePropertyNames$1$1.INSTANCE);
        return object;
    }

    @Override
    protected Set computeClassNames(DescriptorKindFilter descriptorKindFilter, Function1 function1) {
        Intrinsics.checkNotNullParameter(descriptorKindFilter, "kindFilter");
        return SetsKt.emptySet();
    }

    @Override
    public ClassifierDescriptor getContributedClassifier(Name name, LookupLocation lookupLocation) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(lookupLocation, "location");
        return null;
    }

    @Override
    protected void computeNonDeclaredFunctions(Collection collection, Name name) {
        LazyJavaStaticClassScope lazyJavaStaticClassScope = this;
        Intrinsics.checkNotNullParameter(collection, "result");
        Intrinsics.checkNotNullParameter(name, "name");
        Object object = lazyJavaStaticClassScope.getStaticFunctionsFromJavaSuperClasses(name, this.getOwnerDescriptor());
        LazyJavaClassDescriptor lazyJavaClassDescriptor = lazyJavaStaticClassScope.getOwnerDescriptor();
        Set set = object;
        LazyJavaStaticClassScope lazyJavaStaticClassScope2 = this;
        object = lazyJavaStaticClassScope2.getC().getComponents().getErrorReporter();
        OverridingUtil overridingUtil2 = lazyJavaStaticClassScope2.getC().getComponents().getKotlinTypeChecker().getOverridingUtil();
        Collection collection2 = DescriptorResolverUtils.resolveOverridesForStaticMembers(name, set, collection, lazyJavaClassDescriptor, (ErrorReporter)object, overridingUtil2);
        Intrinsics.checkNotNullExpressionValue(collection2, "resolveOverridesForStati\u2026.overridingUtil\n        )");
        collection.addAll(collection2);
        if (this.jClass.isEnum()) {
            if (Intrinsics.areEqual(name, StandardNames.ENUM_VALUE_OF)) {
                SimpleFunctionDescriptor simpleFunctionDescriptor = DescriptorFactory.createEnumValueOfMethod(this.getOwnerDescriptor());
                Intrinsics.checkNotNullExpressionValue(simpleFunctionDescriptor, "createEnumValueOfMethod(ownerDescriptor)");
                collection.add(simpleFunctionDescriptor);
            } else if (Intrinsics.areEqual(name, StandardNames.ENUM_VALUES)) {
                SimpleFunctionDescriptor simpleFunctionDescriptor = DescriptorFactory.createEnumValuesMethod(this.getOwnerDescriptor());
                Intrinsics.checkNotNullExpressionValue(simpleFunctionDescriptor, "createEnumValuesMethod(ownerDescriptor)");
                collection.add(simpleFunctionDescriptor);
            }
        }
    }

    @Override
    protected void computeImplicitlyDeclaredFunctions(Collection collection, Name name) {
        Intrinsics.checkNotNullParameter(collection, "result");
        Intrinsics.checkNotNullParameter(name, "name");
        this.getC().getComponents().getSyntheticPartsProvider().generateStaticFunctions(this.getOwnerDescriptor(), name, collection);
    }

    @Override
    protected void computeNonDeclaredProperties(Name object, Collection collection) {
        LazyJavaStaticClassScope$computeNonDeclaredProperties$propertiesFromSupertypes$1 lazyJavaStaticClassScope$computeNonDeclaredProperties$propertiesFromSupertypes$1;
        LazyJavaStaticClassScope lazyJavaStaticClassScope = lazyJavaClassDescriptor;
        Intrinsics.checkNotNullParameter(object, "name");
        Intrinsics.checkNotNullParameter(collection, "result");
        Object object2 = lazyJavaStaticClassScope$computeNonDeclaredProperties$propertiesFromSupertypes$1;
        lazyJavaStaticClassScope$computeNonDeclaredProperties$propertiesFromSupertypes$1 = new LazyJavaStaticClassScope$computeNonDeclaredProperties$propertiesFromSupertypes$1((Name)object);
        object2 = lazyJavaStaticClassScope.flatMapJavaStaticSupertypesScopes(lazyJavaStaticClassScope.getOwnerDescriptor(), new LinkedHashSet(), (Function1)object2);
        if (collection.isEmpty() ^ true) {
            Name name = object;
            Object object3 = object2;
            LazyJavaStaticClassScope lazyJavaStaticClassScope2 = lazyJavaClassDescriptor;
            LazyJavaClassDescriptor lazyJavaClassDescriptor = lazyJavaStaticClassScope2.getOwnerDescriptor();
            object = lazyJavaStaticClassScope2.getC().getComponents().getErrorReporter();
            object2 = lazyJavaStaticClassScope2.getC().getComponents().getKotlinTypeChecker().getOverridingUtil();
            Collection collection2 = DescriptorResolverUtils.resolveOverridesForStaticMembers(name, (Collection)object3, collection, lazyJavaClassDescriptor, (ErrorReporter)object, (OverridingUtil)object2);
            Intrinsics.checkNotNullExpressionValue(collection2, "resolveOverridesForStati\u2026ingUtil\n                )");
            collection.addAll(collection2);
        } else {
            ArrayList arrayList;
            Object object4;
            MemberDescriptor memberDescriptor;
            Object object5;
            LinkedHashMap linkedHashMap;
            Object object6 = object2;
            object2 = linkedHashMap;
            linkedHashMap = new LinkedHashMap();
            Iterator<Object> iterator2 = object6.iterator();
            while (iterator2.hasNext()) {
                object5 = iterator2.next();
                memberDescriptor = super.getRealOriginal((PropertyDescriptor)object5);
                object4 = object2.get(memberDescriptor);
                if (object4 == null) {
                    ArrayList arrayList2;
                    object4 = arrayList2;
                    arrayList2 = new ArrayList();
                    object2.put(memberDescriptor, object4);
                }
                ((List)object4).add(object5);
            }
            Object object7 = object2;
            object2 = arrayList;
            arrayList = new ArrayList();
            iterator2 = object7.entrySet().iterator();
            while (iterator2.hasNext()) {
                object5 = (Collection)((Map.Entry)iterator2.next()).getValue();
                memberDescriptor = ((LazyJavaStaticClassScope)((Object)lazyJavaClassDescriptor)).getOwnerDescriptor();
                Object object8 = object5;
                LazyJavaClassDescriptor lazyJavaClassDescriptor = lazyJavaClassDescriptor;
                object5 = ((LazyJavaScope)((Object)lazyJavaClassDescriptor)).getC().getComponents().getErrorReporter();
                object4 = ((LazyJavaScope)((Object)lazyJavaClassDescriptor)).getC().getComponents().getKotlinTypeChecker().getOverridingUtil();
                Collection collection3 = DescriptorResolverUtils.resolveOverridesForStaticMembers((Name)object, object8, collection, (ClassDescriptor)memberDescriptor, object5, object4);
                Intrinsics.checkNotNullExpressionValue(collection3, "resolveOverridesForStati\u2026ingUtil\n                )");
                CollectionsKt.addAll((Collection)object2, collection3);
            }
            collection.addAll(object2);
        }
    }
}

