/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.name;

import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.FqNameUnsafe$1;
import kotlin.reflect.jvm.internal.impl.name.Name;

public final class FqNameUnsafe {
    private static final Name ROOT_NAME = Name.special("<root>");
    private static final Pattern SPLIT_BY_DOTS = Pattern.compile("\\.");
    private static final Function1 STRING_TO_NAME = new FqNameUnsafe$1();
    private final String fqName;
    private transient FqName safe;
    private transient FqNameUnsafe parent;
    private transient Name shortName;

    FqNameUnsafe(String string, FqName fqName2) {
        if (string == null) {
            FqNameUnsafe.$$$reportNull$$$0(0);
        }
        if (fqName2 == null) {
            FqNameUnsafe.$$$reportNull$$$0(1);
        }
        this.fqName = string;
        this.safe = fqName2;
    }

    public FqNameUnsafe(String string) {
        if (string == null) {
            FqNameUnsafe.$$$reportNull$$$0(2);
        }
        this.fqName = string;
    }

    private FqNameUnsafe(String string, FqNameUnsafe fqNameUnsafe, Name name) {
        if (string == null) {
            FqNameUnsafe.$$$reportNull$$$0(3);
        }
        this.fqName = string;
        this.parent = fqNameUnsafe;
        this.shortName = name;
    }

    private void compute() {
        int n = this.fqName.lastIndexOf(46);
        if (n >= 0) {
            this.shortName = Name.guessByFirstCharacter(this.fqName.substring(n + 1));
            this.parent = new FqNameUnsafe(this.fqName.substring(0, n));
        } else {
            this.shortName = Name.guessByFirstCharacter(this.fqName);
            this.parent = FqName.ROOT.toUnsafe();
        }
    }

    public static FqNameUnsafe topLevel(Name name) {
        if (name == null) {
            FqNameUnsafe.$$$reportNull$$$0(16);
        }
        return new FqNameUnsafe(name.asString(), FqName.ROOT.toUnsafe(), name);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        int n2;
        Object object;
        switch (n) {
            default: {
                object = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 17: {
                object = "@NotNull method %s.%s must not return null";
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 17: {
                n2 = 2;
            }
        }
        Object[] objectArray = new Object[n2];
        if (n != 1) {
            switch (n) {
                default: {
                    objectArray[0] = "fqName";
                    break;
                }
                case 16: {
                    objectArray[0] = "shortName";
                    break;
                }
                case 15: {
                    objectArray[0] = "segment";
                    break;
                }
                case 9: {
                    objectArray[0] = "name";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 17: {
                    objectArray[0] = "kotlin/reflect/jvm/internal/impl/name/FqNameUnsafe";
                    break;
                }
            }
        } else {
            objectArray[0] = "safe";
        }
        switch (n) {
            default: {
                objectArray[1] = "kotlin/reflect/jvm/internal/impl/name/FqNameUnsafe";
                break;
            }
            case 17: {
                objectArray[1] = "toString";
                break;
            }
            case 14: {
                objectArray[1] = "pathSegments";
                break;
            }
            case 12: 
            case 13: {
                objectArray[1] = "shortNameOrSpecial";
                break;
            }
            case 10: 
            case 11: {
                objectArray[1] = "shortName";
                break;
            }
            case 7: 
            case 8: {
                objectArray[1] = "parent";
                break;
            }
            case 5: 
            case 6: {
                objectArray[1] = "toSafe";
                break;
            }
            case 4: {
                objectArray[1] = "asString";
            }
        }
        switch (n) {
            default: {
                objectArray[2] = "<init>";
                break;
            }
            case 16: {
                objectArray[2] = "topLevel";
                break;
            }
            case 15: {
                objectArray[2] = "startsWith";
                break;
            }
            case 9: {
                objectArray[2] = "child";
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
        }
        String string = String.format((String)object, objectArray);
        switch (n) {
            default: {
                IllegalArgumentException illegalArgumentException;
                object = illegalArgumentException;
                illegalArgumentException = new IllegalArgumentException(string);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 17: {
                IllegalStateException illegalStateException;
                object = illegalStateException;
                illegalStateException = new IllegalStateException(string);
            }
        }
        throw object;
    }

    public String asString() {
        String string = ((FqNameUnsafe)((Object)string)).fqName;
        if (string == null) {
            FqNameUnsafe.$$$reportNull$$$0(4);
        }
        return string;
    }

    public boolean isSafe() {
        return this.safe != null || this.asString().indexOf(60) < 0;
    }

    public FqName toSafe() {
        FqName fqName2;
        FqName fqName3 = this.safe;
        if (fqName3 != null) {
            if (fqName3 == null) {
                FqNameUnsafe.$$$reportNull$$$0(5);
            }
            return fqName3;
        }
        fqName3 = fqName2;
        fqName3(this);
        this.safe = fqName3;
        return fqName2;
    }

    public boolean isRoot() {
        return this.fqName.isEmpty();
    }

    public FqNameUnsafe parent() {
        FqNameUnsafe fqNameUnsafe = fqNameUnsafe3.parent;
        if (fqNameUnsafe != null) {
            if (fqNameUnsafe == null) {
                FqNameUnsafe.$$$reportNull$$$0(7);
            }
            return fqNameUnsafe;
        }
        if (!fqNameUnsafe3.isRoot()) {
            FqNameUnsafe fqNameUnsafe2 = fqNameUnsafe3;
            fqNameUnsafe2.compute();
            FqNameUnsafe fqNameUnsafe3 = fqNameUnsafe2.parent;
            if (fqNameUnsafe3 == null) {
                FqNameUnsafe.$$$reportNull$$$0(8);
            }
            return fqNameUnsafe3;
        }
        throw new IllegalStateException("root");
    }

    public FqNameUnsafe child(Name name) {
        if (name == null) {
            FqNameUnsafe.$$$reportNull$$$0(9);
        }
        String string = this.isRoot() ? name.asString() : this.fqName + "." + name.asString();
        return new FqNameUnsafe(string, this, name);
    }

    public Name shortName() {
        Name name = ((FqNameUnsafe)((Object)name2)).shortName;
        if (name != null) {
            if (name == null) {
                FqNameUnsafe.$$$reportNull$$$0(10);
            }
            return name;
        }
        if (!((FqNameUnsafe)((Object)name2)).isRoot()) {
            FqNameUnsafe fqNameUnsafe = name2;
            fqNameUnsafe.compute();
            Name name2 = fqNameUnsafe.shortName;
            if (name2 == null) {
                FqNameUnsafe.$$$reportNull$$$0(11);
            }
            return name2;
        }
        throw new IllegalStateException("root");
    }

    public Name shortNameOrSpecial() {
        if (((FqNameUnsafe)object).isRoot()) {
            Object object = ROOT_NAME;
            if (object == null) {
                FqNameUnsafe.$$$reportNull$$$0(12);
            }
            return object;
        }
        if ((object = ((FqNameUnsafe)object).shortName()) == null) {
            FqNameUnsafe.$$$reportNull$$$0(13);
        }
        return object;
    }

    public List pathSegments() {
        if ((this = ((FqNameUnsafe)((Object)this)).isRoot() ? Collections.emptyList() : ArraysKt.map(SPLIT_BY_DOTS.split(((FqNameUnsafe)((Object)this)).fqName), STRING_TO_NAME)) == null) {
            FqNameUnsafe.$$$reportNull$$$0(14);
        }
        return this;
    }

    public boolean startsWith(Name object) {
        if (object == null) {
            FqNameUnsafe.$$$reportNull$$$0(15);
        }
        if (this.isRoot()) {
            return false;
        }
        int n = this.fqName.indexOf(46);
        Name name = object;
        object = this.fqName;
        int n2 = 0;
        String string = name.asString();
        int n3 = 0;
        if (n == -1) {
            n = this.fqName.length();
        }
        return ((String)object).regionMatches(n2, string, n3, n);
    }

    public String toString() {
        if ((this = ((FqNameUnsafe)this).isRoot() ? ROOT_NAME.asString() : ((FqNameUnsafe)this).fqName) == null) {
            FqNameUnsafe.$$$reportNull$$$0(17);
        }
        return this;
    }

    public boolean equals(Object object) {
        if (fqNameUnsafe2 == object) {
            return true;
        }
        if (!(object instanceof FqNameUnsafe)) {
            return false;
        }
        FqNameUnsafe fqNameUnsafe = fqNameUnsafe2;
        FqNameUnsafe fqNameUnsafe2 = (FqNameUnsafe)object;
        return fqNameUnsafe.fqName.equals(fqNameUnsafe2.fqName);
    }

    public int hashCode() {
        return this.fqName.hashCode();
    }
}

