/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.protobuf;

import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import kotlin.reflect.jvm.internal.impl.protobuf.ByteString$Output;
import kotlin.reflect.jvm.internal.impl.protobuf.Internal;
import kotlin.reflect.jvm.internal.impl.protobuf.LiteralByteString;
import kotlin.reflect.jvm.internal.impl.protobuf.RopeByteString;

public abstract class ByteString
implements Iterable {
    public static final ByteString EMPTY;
    static final /* synthetic */ boolean $assertionsDisabled;

    ByteString() {
    }

    public static ByteString copyFrom(byte[] byArray, int n, int n2) {
        byte[] byArray2 = byArray;
        byArray = new byte[n2];
        System.arraycopy(byArray2, n, byArray, 0, n2);
        return new LiteralByteString(byArray);
    }

    public static ByteString copyFrom(byte[] byArray) {
        return ByteString.copyFrom(byArray, 0, byArray.length);
    }

    public static ByteString copyFromUtf8(String string) {
        try {
            return new LiteralByteString(string.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("UTF-8 not supported?", unsupportedEncodingException);
        }
    }

    public static ByteString copyFrom(Iterable iterable) {
        if (!(iterable instanceof Collection)) {
            ArrayList arrayList;
            Iterable iterable2 = iterable;
            iterable = arrayList;
            arrayList = new ArrayList();
            Iterator iterator2 = iterable2.iterator();
            while (iterator2.hasNext()) {
                iterable.add((ByteString)iterator2.next());
            }
        } else {
            iterable = (Collection)iterable;
        }
        return iterable.isEmpty() ? EMPTY : ByteString.balancedConcat(iterable.iterator(), iterable.size());
    }

    private static ByteString balancedConcat(Iterator iterator2, int n) {
        ByteString byteString;
        if (!$assertionsDisabled && n < 1) {
            throw new AssertionError();
        }
        if (n == 1) {
            byteString = (ByteString)iterator2.next();
        } else {
            int n2 = n >>> 1;
            byteString = ByteString.balancedConcat(iterator2, n2).concat(ByteString.balancedConcat(iterator2, n - n2));
        }
        return byteString;
    }

    public static ByteString$Output newOutput() {
        return new ByteString$Output(128);
    }

    static {
        $assertionsDisabled = ByteString.class.desiredAssertionStatus() ^ true;
        EMPTY = new LiteralByteString(new byte[0]);
    }

    public abstract int size();

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public ByteString concat(ByteString byteString) {
        int n;
        int n2 = this.size();
        if ((long)n2 + (long)(n = byteString.size()) < Integer.MAX_VALUE) {
            return RopeByteString.concatenate(this, byteString);
        }
        throw new IllegalArgumentException(new StringBuilder(53).append("ByteString would be too long: ").append(n2).append("+").append(n).toString());
    }

    public void copyTo(byte[] byArray, int n, int n2, int n3) {
        if (n >= 0) {
            if (n2 >= 0) {
                if (n3 >= 0) {
                    int n4 = n + n3;
                    if (n4 <= this.size()) {
                        n4 = n2 + n3;
                        if (n4 <= byArray.length) {
                            if (n3 > 0) {
                                this.copyToInternal(byArray, n, n2, n3);
                            }
                            return;
                        }
                        throw new IndexOutOfBoundsException(new StringBuilder(34).append("Target end offset < 0: ").append(n4).toString());
                    }
                    throw new IndexOutOfBoundsException(new StringBuilder(34).append("Source end offset < 0: ").append(n4).toString());
                }
                throw new IndexOutOfBoundsException(new StringBuilder(23).append("Length < 0: ").append(n3).toString());
            }
            throw new IndexOutOfBoundsException(new StringBuilder(30).append("Target offset < 0: ").append(n2).toString());
        }
        throw new IndexOutOfBoundsException(new StringBuilder(30).append("Source offset < 0: ").append(n).toString());
    }

    protected abstract void copyToInternal(byte[] var1, int var2, int var3, int var4);

    public byte[] toByteArray() {
        int n = this.size();
        if (n == 0) {
            return Internal.EMPTY_BYTE_ARRAY;
        }
        byte[] byArray = new byte[n];
        this.copyToInternal(byArray, 0, 0, n);
        return byArray;
    }

    void writeTo(OutputStream outputStream, int n, int n2) {
        if (n >= 0) {
            if (n2 >= 0) {
                int n3 = n + n2;
                if (n3 <= this.size()) {
                    if (n2 > 0) {
                        this.writeToInternal(outputStream, n, n2);
                    }
                    return;
                }
                throw new IndexOutOfBoundsException(new StringBuilder(39).append("Source end offset exceeded: ").append(n3).toString());
            }
            throw new IndexOutOfBoundsException(new StringBuilder(23).append("Length < 0: ").append(n2).toString());
        }
        throw new IndexOutOfBoundsException(new StringBuilder(30).append("Source offset < 0: ").append(n).toString());
    }

    abstract void writeToInternal(OutputStream var1, int var2, int var3);

    public abstract String toString(String var1);

    public String toStringUtf8() {
        try {
            return this.toString("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("UTF-8 not supported?", unsupportedEncodingException);
        }
    }

    public abstract boolean isValidUtf8();

    protected abstract int partialIsValidUtf8(int var1, int var2, int var3);

    protected abstract int getTreeDepth();

    protected abstract boolean isBalanced();

    protected abstract int peekCachedHashCode();

    protected abstract int partialHash(int var1, int var2, int var3);

    public String toString() {
        Object[] objectArray = new Object[2];
        Object[] objectArray2 = objectArray;
        objectArray2[0] = Integer.toHexString(System.identityHashCode(this));
        objectArray[1] = this.size();
        return String.format("<ByteString@%s size=%d>", objectArray2);
    }
}

