/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.authenticator;

import java.net.Authenticator;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.SocketAddress;
import java.net.URL;
import java.util.Iterator;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.Address;
import okhttp3.Authenticator;
import okhttp3.Challenge;
import okhttp3.Credentials;
import okhttp3.Dns;
import okhttp3.HttpUrl;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.Route;
import okhttp3.internal.authenticator.JavaNetAuthenticator$WhenMappings;

public final class JavaNetAuthenticator
implements Authenticator {
    private final Dns defaultDns;

    public JavaNetAuthenticator(Dns dns) {
        Intrinsics.checkNotNullParameter(dns, "defaultDns");
        this.defaultDns = dns;
    }

    public /* synthetic */ JavaNetAuthenticator(Dns dns, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            dns = Dns.SYSTEM;
        }
        this(dns);
    }

    private final InetAddress connectToInetAddress(Proxy proxy, HttpUrl httpUrl, Dns dns) {
        block4: {
            block3: {
                Object object;
                block2: {
                    object = proxy.type();
                    if ((object == null ? -1 : JavaNetAuthenticator$WhenMappings.$EnumSwitchMapping$0[((Enum)object).ordinal()]) != 1) break block2;
                    object = (InetAddress)CollectionsKt.first(dns.lookup(httpUrl.host()));
                    break block3;
                }
                object = proxy.address();
                if (object == null) break block4;
                object = ((InetSocketAddress)object).getAddress();
                Intrinsics.checkNotNullExpressionValue(object, "address() as InetSocketAddress).address");
            }
            return object;
        }
        throw new NullPointerException("null cannot be cast to non-null type java.net.InetSocketAddress");
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public Request authenticate(Route object, Response iterator2) {
        String string;
        Object object2;
        Challenge challenge;
        Iterator iterator3 = iterator2;
        Intrinsics.checkNotNullParameter(iterator3, "response");
        iterator2 = ((Response)((Object)iterator3)).challenges();
        Request request = ((Response)((Object)iterator3)).request();
        HttpUrl httpUrl = request.url();
        boolean bl = ((Response)((Object)iterator3)).code() == 407;
        Proxy proxy = object == null ? null : ((Route)object).proxy();
        if (proxy == null) {
            proxy = Proxy.NO_PROXY;
        }
        iterator2 = iterator2.iterator();
        while (true) {
            URL uRL;
            String string2;
            String string3;
            String string4;
            int n;
            if (!iterator2.hasNext()) {
                return null;
            }
            challenge = (Challenge)iterator2.next();
            if (!StringsKt.equals("Basic", challenge.scheme(), true)) continue;
            object2 = object == null || (object2 = ((Route)object).address()) == null ? null : ((Address)object2).dns();
            if (object2 == null) {
                object2 = ((JavaNetAuthenticator)((Object)string7)).defaultDns;
            }
            if (bl) {
                SocketAddress socketAddress = proxy.address();
                if (socketAddress == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.net.InetSocketAddress");
                }
                socketAddress = (InetSocketAddress)socketAddress;
                String string5 = ((InetSocketAddress)socketAddress).getHostName();
                Challenge challenge2 = challenge;
                Proxy proxy2 = proxy;
                Intrinsics.checkNotNullExpressionValue(proxy2, "proxy");
                object2 = ((JavaNetAuthenticator)((Object)string7)).connectToInetAddress(proxy2, httpUrl, (Dns)object2);
                n = ((InetSocketAddress)socketAddress).getPort();
                string4 = httpUrl.scheme();
                string3 = challenge2.realm();
                string2 = challenge2.scheme();
                uRL = httpUrl.url();
                Object object3 = object2;
                object2 = Authenticator.RequestorType.PROXY;
                object2 = java.net.Authenticator.requestPasswordAuthentication(string5, (InetAddress)object3, n, string4, string3, string2, uRL, (Authenticator.RequestorType)((Object)object2));
            } else {
                String string6 = httpUrl.host();
                Challenge challenge3 = challenge;
                HttpUrl httpUrl2 = httpUrl;
                Proxy proxy3 = proxy;
                Intrinsics.checkNotNullExpressionValue(proxy3, "proxy");
                object2 = ((JavaNetAuthenticator)((Object)string7)).connectToInetAddress(proxy3, httpUrl, (Dns)object2);
                n = httpUrl2.port();
                string4 = httpUrl2.scheme();
                string3 = challenge3.realm();
                string2 = challenge3.scheme();
                uRL = httpUrl.url();
                Object object4 = object2;
                object2 = Authenticator.RequestorType.SERVER;
                object2 = java.net.Authenticator.requestPasswordAuthentication(string6, (InetAddress)object4, n, string4, string3, string2, uRL, (Authenticator.RequestorType)((Object)object2));
            }
            if (object2 != null) break;
        }
        String string7 = bl ? "Proxy-Authorization" : "Authorization";
        String string8 = ((PasswordAuthentication)object2).getUserName();
        Intrinsics.checkNotNullExpressionValue(string8, "auth.userName");
        object = string;
        char[] cArray = ((PasswordAuthentication)object2).getPassword();
        Intrinsics.checkNotNullExpressionValue(cArray, "auth.password");
        string = new String(cArray);
        object = Credentials.basic(string8, (String)object, challenge.charset());
        return request.newBuilder().header(string7, (String)object).build();
    }
}

